% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdal_helpers.R
\name{make_chunk_index}
\alias{make_chunk_index}
\title{Generate an index of chunk offsets and sizes for iterating a raster}
\usage{
make_chunk_index(
  raster_xsize,
  raster_ysize,
  block_xsize,
  block_ysize,
  gt = c(0, 1, 0, 0, 0, 1),
  max_pixels = 0
)
}
\arguments{
\item{raster_xsize}{Integer value giving the number of raster columns.}

\item{raster_ysize}{Integer value giving the number of raster rows.}

\item{block_xsize}{Integer value giving the horizontal size of a raster block
in number of pixels.}

\item{block_ysize}{Integer value giving the vertical size of a raster block
in number of pixels.}

\item{gt}{A numeric vector of length six containing the affine geotransform
for the raster (defaults to \code{c(0, 1, 0, 0, 0, 1)}). Required only if
geospatial bounding boxes of the chunks are needed in the output.}

\item{max_pixels}{Numeric value (a whole number), optionally carrying the
\code{bit64::integer64} class attribute. Specifies the maximum number of pixels
per chunk. Can be set to zero to define chunks as the blocks.}
}
\value{
A numeric matrix with number of rows equal to the number of chunks,
and named columns: \code{xchunkoff}, \code{ychunkoff}, \code{xoff}, \code{yoff}, \code{xsize},
\code{ysize}, \code{xmin}, \code{xmax}, \code{ymin}, \code{ymax}. Offsets are 0-based.
}
\description{
\code{make_chunk_index()} returns a matrix of \code{xchunkoff}, \code{ychunkoff}, \code{xoff},
\code{yoff}, \code{xsize}, \code{ysize}, \code{xmin}, \code{xmax}, \code{ymin} and \code{ymax}, i.e., indexing
of potentially multi-block chunks defined on block boundaries for iterating
I/O operations over a raster. The last four columns are geospatial
coordinates of the bounding box. Note that class \code{GDALRaster} provides a
method of the same name that is more convenient to use with a dataset object.
}
\details{
The stand-alone function here supports the general case of chunking/tiling a
raster layout without using a dataset object. If the \code{max_pixels} argument
is set to zero, the chunks are raster blocks (the internal tiles in the case
of a tiled format). Otherwise, chunks are defined as the maximum number of
consecutive whole blocks containing \verb{<= max_pixels}, that may span one or
multiple whole rows of blocks.
}
\examples{
## chunk as one block
blocks <- make_chunk_index(raster_xsize = 156335, raster_ysize = 101538,
                           block_xsize = 256, block_ysize = 256,
                           gt = c(-2362395, 30, 0, 3267405, 0, -30),
                           max_pixels = 0)

nrow(blocks)

head(blocks)

tail(blocks)

## chunk as 16 consectutive blocks
chunks <- make_chunk_index(raster_xsize = 156335, raster_ysize = 101538,
                           block_xsize = 256, block_ysize = 256,
                           gt = c(-2362395, 30, 0, 3267405, 0, -30),
                           max_pixels = 256 * 256 * 16)

nrow(chunks)

head(chunks)

tail(chunks)
}
\seealso{
Methods \code{make_chunk_index()}, \code{readChunk()} and
\code{writeChunk()} in class \link{GDALRaster}.

Usage example in the web article
\href{https://firelab.github.io/gdalraster/articles/gdal-block-cache.html}{GDAL Block Cache}.
}
