% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noisemaker.R
\name{noisemaker}
\alias{noisemaker}
\title{Simulate a population correlation matrix with model error}
\usage{
noisemaker(
  mod,
  method = c("TKL", "CB", "WB"),
  target_rmsea = 0.05,
  target_cfi = NULL,
  tkl_ctrl = list(),
  wb_mod = NULL
)
}
\arguments{
\item{mod}{A \code{\link[fungible]{simFA}} model object.}

\item{method}{(character) Model error method to use ("TKL", "CB", or "WB").}

\item{target_rmsea}{(scalar) Target RMSEA value.}

\item{target_cfi}{(scalar) Target CFI value.}

\item{tkl_ctrl}{(list) A control list containing the following TKL-specific
arguments. See the \code{\link{tkl}} help file for more details.}

\item{wb_mod}{(`lm` object) An optional \code{\link[stats]{lm}} object used
to find a target RMSEA value that results in solutions with RMSEA values
close to the desired value. Note that if no `wb_mod` is provided, a model
will be estimated at run time. If many population correlation matrices are
going to be simulated using the same model, it will be considerably faster
to estimate `wb_mod` ahead of time. See also \code{\link{get_wb_mod}}.}
}
\value{
A list containing \eqn{\Sigma}, RMSEA and CFI values, and the TKL
  parameters (if applicable).
}
\description{
This tool lets the user generate a population correlation matrix with model
error using one of three methods: (1) the Tucker, Koopman, and Linn (TKL;
1969) method, (2) the Cudeck and Browne (CB; 1992) method, or (3) the Wu and
Browne (WB; 2015) method. If the CB or WB methods are used, the user can
specify the desired RMSEA value. If the TKL method is used, an optimization
procedure finds a solution that produces RMSEA and/or CFI values that are
close to the user-specified values.
}
\examples{
mod <- fungible::simFA(Seed = 42)

set.seed(42)
# Simulate a population correlation matrix using the TKL method with target
# RMSEA and CFI values specified.
noisemaker(mod, method = "TKL",
           target_rmsea = 0.05,
           target_cfi = 0.95,
           tkl_ctrl = list(optim_type = "optim"))

# Simulate a population correlation matrix using the CB method with target
# RMSEA value specified.
noisemaker(mod, method = "CB",
           target_rmsea = 0.05)

# Simulation a population correlation matrix using the WB method with target
# RMSEA value specified.
noisemaker(mod,
           method = "WB",
           target_rmsea = 0.05)
}
