% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_matrix.R
\name{scale_med}
\alias{scale_med}
\title{Robust scaling}
\usage{
scale_med(mat, TOL = 1e-08, drop_const = TRUE, doRows = FALSE)
}
\arguments{
\item{mat}{A numeric matrix. Its columns will be centered and scaled.}

\item{TOL}{Columns with MAD below this value will be considered constant.
Default: \code{1e-8}}

\item{drop_const}{Drop constant columns? Default: \code{TRUE}. If
\code{FALSE}, set to \code{NA} instead.}

\item{doRows}{Center and scale the rows instead? Default: \code{FALSE}.}
}
\value{
The input matrix with its columns centered and scaled.
}
\description{
Centers and scales the columns of a matrix robustly
}
\details{
Centers each column on its median, and scales each column by its median
absolute deviation (MAD). If there are constant-valued columns, they are
removed if \code{drop_const} or set to \code{NA} if \code{!drop_const}, and
a warning is raised. If all columns are constant, an error is raised.
}
