% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolution.R
\name{send_buttons}
\alias{send_buttons}
\title{Send Buttons}
\usage{
send_buttons(
  client,
  number,
  title,
  description,
  footer,
  buttons,
  delay = NULL,
  link_preview = NULL,
  mentions_everyone = NULL,
  verbose = FALSE
)
}
\arguments{
\item{client}{An \code{\link[=evo_client]{evo_client()}} object.}

\item{number}{Character. Recipient in E.164 format (e.g., \code{"+5581999..."}).}

\item{title, description, footer}{Character.}

\item{buttons}{List of buttons (see API docs).}

\item{delay}{Integer (ms). Optional presence delay before sending.}

\item{link_preview}{Logical. Enable URL link preview.}

\item{mentions_everyone}{Logical. Mention everyone (if applicable).}

\item{verbose}{Logical. If TRUE, logs request/response details.}
}
\value{
A named list parsed from the Evolution API JSON response, with metadata
describing the button message (IDs, timestamps, queue details, and
button structure as accepted by the server). Note:  Buttons may be discontinued on Baileys mode; supported on Cloud API.
The HTTP status code is stored in \code{attr(result, "http_status")}.
This output reflects the server acknowledgement of the button message send.
}
\description{
Send Buttons
}
\details{
Buttons may be discontinued on Baileys mode; supported on Cloud API.
}
