//===----------------------------------------------------------------------===//
//                         DuckDB
//
// core_functions/aggregate/regression_functions.hpp
//
//
//===----------------------------------------------------------------------===//
// This file is automatically generated by scripts/generate_functions.py
// Do not edit this file manually, your changes will be overwritten
//===----------------------------------------------------------------------===//

#pragma once

#include "duckdb/function/function_set.hpp"

namespace duckdb {

struct RegrAvgxFun {
	static constexpr const char *Name = "regr_avgx";
	static constexpr const char *Parameters = "y,x";
	static constexpr const char *Description = "Returns the average of the independent variable for non-NULL pairs in a group, where x is the independent variable and y is the dependent variable.";
	static constexpr const char *Example = "";
	static constexpr const char *Categories = "";

	static AggregateFunction GetFunction();
};

struct RegrAvgyFun {
	static constexpr const char *Name = "regr_avgy";
	static constexpr const char *Parameters = "y,x";
	static constexpr const char *Description = "Returns the average of the dependent variable for non-NULL pairs in a group, where x is the independent variable and y is the dependent variable.";
	static constexpr const char *Example = "";
	static constexpr const char *Categories = "";

	static AggregateFunction GetFunction();
};

struct RegrCountFun {
	static constexpr const char *Name = "regr_count";
	static constexpr const char *Parameters = "y,x";
	static constexpr const char *Description = "Returns the number of non-NULL number pairs in a group.";
	static constexpr const char *Example = "(SUM(x*y) - SUM(x) * SUM(y) / COUNT(*)) / COUNT(*)";
	static constexpr const char *Categories = "";

	static AggregateFunction GetFunction();
};

struct RegrInterceptFun {
	static constexpr const char *Name = "regr_intercept";
	static constexpr const char *Parameters = "y,x";
	static constexpr const char *Description = "Returns the intercept of the univariate linear regression line for non-NULL pairs in a group.";
	static constexpr const char *Example = "AVG(y)-REGR_SLOPE(y, x)*AVG(x)";
	static constexpr const char *Categories = "";

	static AggregateFunction GetFunction();
};

struct RegrR2Fun {
	static constexpr const char *Name = "regr_r2";
	static constexpr const char *Parameters = "y,x";
	static constexpr const char *Description = "Returns the coefficient of determination for non-NULL pairs in a group.";
	static constexpr const char *Example = "";
	static constexpr const char *Categories = "";

	static AggregateFunction GetFunction();
};

struct RegrSlopeFun {
	static constexpr const char *Name = "regr_slope";
	static constexpr const char *Parameters = "y,x";
	static constexpr const char *Description = "Returns the slope of the linear regression line for non-NULL pairs in a group.";
	static constexpr const char *Example = "COVAR_POP(x, y) / VAR_POP(x)";
	static constexpr const char *Categories = "";

	static AggregateFunction GetFunction();
};

struct RegrSXXFun {
	static constexpr const char *Name = "regr_sxx";
	static constexpr const char *Parameters = "y,x";
	static constexpr const char *Description = "";
	static constexpr const char *Example = "REGR_COUNT(y, x) * VAR_POP(x)";
	static constexpr const char *Categories = "";

	static AggregateFunction GetFunction();
};

struct RegrSXYFun {
	static constexpr const char *Name = "regr_sxy";
	static constexpr const char *Parameters = "y,x";
	static constexpr const char *Description = "Returns the population covariance of input values";
	static constexpr const char *Example = "REGR_COUNT(y, x) * COVAR_POP(y, x)";
	static constexpr const char *Categories = "";

	static AggregateFunction GetFunction();
};

struct RegrSYYFun {
	static constexpr const char *Name = "regr_syy";
	static constexpr const char *Parameters = "y,x";
	static constexpr const char *Description = "";
	static constexpr const char *Example = "REGR_COUNT(y, x) * VAR_POP(y)";
	static constexpr const char *Categories = "";

	static AggregateFunction GetFunction();
};

} // namespace duckdb
