% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dice_facet.R
\name{dice_facet_plot}
\alias{dice_facet_plot}
\title{Domino Plot Visualization with Categorical Colors}
\usage{
dice_facet_plot(
  data,
  gene_list,
  x = "gene",
  y = "Celltype",
  contrast = "Contrast",
  var_id = "var",
  spacing_factor = 3,
  categorical_colors = NULL,
  color_scale_name = "Category",
  left_rect_color = "lightblue",
  right_rect_color = "lightpink",
  rect_alpha = 0.5,
  axis_text_size = 8,
  x_axis_text_size = NULL,
  y_axis_text_size = NULL,
  legend_text_size = 8,
  cluster_method = "complete",
  cluster_y_axis = TRUE,
  cluster_var_id = TRUE,
  base_width = 5,
  base_height = 4,
  show_legend = TRUE,
  legend_width = 0.25,
  legend_height = 0.5,
  custom_legend = TRUE,
  aspect_ratio = NULL,
  switch_axis = FALSE,
  reverse_y_ordering = FALSE,
  show_var_positions = FALSE,
  output_file = NULL,
  feature_col = NULL,
  celltype_col = NULL,
  contrast_col = NULL
)
}
\arguments{
\item{data}{A data frame containing the categorical data.}

\item{gene_list}{A character vector of gene names to include in the plot.}

\item{x}{A string representing the column name in \code{data} for the feature variable (e.g., genes). Default is \code{"gene"}.}

\item{y}{A string representing the column name in \code{data} for the cell type variable. Default is \code{"Celltype"}.}

\item{contrast}{A string representing the column name in \code{data} for the contrast variable. Default is \code{"Contrast"}.}

\item{var_id}{A string representing the column name in \code{data} for the variable identifier. Default is \code{"var"}.}

\item{spacing_factor}{A numeric value indicating the spacing between gene pairs. Default is \code{3}.}

\item{categorical_colors}{A named vector of colors to use for categorical values in the data. Default is NULL.}

\item{color_scale_name}{A string specifying the name of the color scale in the legend. Default is \code{"Category"}.}

\item{left_rect_color}{A string specifying the color for the left rectangles. Default is \code{"lightblue"}.}

\item{right_rect_color}{A string specifying the color for the right rectangles. Default is \code{"lightpink"}.}

\item{rect_alpha}{A numeric value between 0 and 1 indicating the transparency of the rectangles. Default is \code{0.5}.}

\item{axis_text_size}{A numeric value specifying the size of the axis text. Default is \code{8}.}

\item{x_axis_text_size}{A numeric value specifying the size of the x-axis text. If NULL, uses \code{axis_text_size}. Default is \code{NULL}.}

\item{y_axis_text_size}{A numeric value specifying the size of the y-axis text. If NULL, uses \code{axis_text_size}. Default is \code{NULL}.}

\item{legend_text_size}{A numeric value specifying the size of the legend text. Default is \code{8}.}

\item{cluster_method}{The clustering method to use. Default is \code{"complete"}.}

\item{cluster_y_axis}{A logical value indicating whether to cluster the y-axis (cell types). Default is \code{TRUE}.}

\item{cluster_var_id}{A logical value indicating whether to cluster the var_id. Default is \code{TRUE}.}

\item{base_width}{A numeric value specifying the base width for saving the plot. Default is \code{5}.}

\item{base_height}{A numeric value specifying the base height for saving the plot. Default is \code{4}.}

\item{show_legend}{A logical value indicating whether to show the legend. Default is \code{TRUE}.}

\item{legend_width}{A numeric value specifying the relative width of the legend. Default is \code{0.25}.}

\item{legend_height}{A numeric value specifying the relative height of the legend. Default is \code{0.5}.}

\item{custom_legend}{A logical value indicating whether to use a custom legend. Default is \code{TRUE}.}

\item{aspect_ratio}{A numeric value specifying the aspect ratio of the plot. If \code{NULL}, it's calculated automatically. Default is \code{NULL}.}

\item{switch_axis}{A logical value indicating whether to switch the x and y axes. Default is \code{FALSE}.}

\item{reverse_y_ordering}{A logical value indicating whether to reverse the y-axis ordering after clustering. Default is \code{FALSE}.}

\item{show_var_positions}{A logical value indicating whether to show the intermediate variable positions plot. Default is \code{FALSE}.
When \code{output_file} is specified with a PDF extension, both plots will be saved to a multi-page PDF if this is \code{TRUE}.
A warning will be shown if \code{show_var_positions} is \code{TRUE} but the output file is not a PDF.}

\item{output_file}{An optional string specifying the path to save the plot. If \code{NULL}, the plot is not saved. Default is \code{NULL}.}

\item{feature_col}{Deprecated. Use \code{x} instead.}

\item{celltype_col}{Deprecated. Use \code{y} instead.}

\item{contrast_col}{Deprecated. Use \code{contrast} instead.}
}
\value{
A list containing the domino plot and optionally the variable positions plot.
}
\description{
This function generates a plot to visualize categorical data in a domino plot format. The size of the dots is fixed, and the plot can be saved to an output file if specified.
This version supports categorical colors and allows setting colors for left and right rectangle plots.
}
