% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.deepspat_MSP.R
\name{summary.deepspat_MSP}
\alias{summary.deepspat_MSP}
\title{Deep compositional spatial model for max-stable processes}
\usage{
\method{summary}{deepspat_MSP}(object, newdata, uncAss = TRUE, edm_emp = NULL, ...)
}
\arguments{
\item{object}{a deepspat object obtained from fitting a deep compositional spatial model for extremes using max-stable processes.}

\item{newdata}{a data frame containing the prediction locations.}

\item{uncAss}{assess the uncertainty of dependence parameters or not}

\item{edm_emp}{empirical estimates of extremal dependence measure for weighted least square inference method}

\item{...}{currently unused}
}
\value{
A list with the following components:
\describe{
  \item{srescaled}{A matrix of rescaled spatial coordinates produced by scaling the input locations.}
  \item{swarped}{A matrix of warped spatial coordinates. For \code{family = "power_stat"} this equals \code{srescaled}, while for \code{family = "power_nonstat"}
  the coordinates are further transformed through additional layers.}
  \item{fitted.phi}{A numeric value representing the fitted spatial range parameter, computed as \code{exp(logphi_tf)}.}
  \item{fitted.kappa}{A numeric value representing the fitted smoothness parameter, computed as \code{2 * sigmoid(logitkappa_tf)}.}
  \item{Sigma.psi}{A numeric matrix giving the estimated covariance matrix of the
    dependence parameters \eqn{\psi = (\phi, \kappa)}, computed via the
    pairwise likelihood / WLS sandwich-type estimator. \code{NULL} if
    \code{uncAss = FALSE}.}
}
}
\description{
Prediction function for the fitted deepspat_ext object
}
