% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-maple.r
\docType{data}
\name{maple}
\alias{maple}
\title{Tree biomass of sugar maple (Acer saccharum) trees.}
\format{
Contains tree-level variables, as follows:
\describe{
\item{tree}{Sample tree identification number.}
\item{dbh}{Diameter at breast height, in cm}
\item{leaf}{Leaf biomass, in kg.}
\item{branch}{Branches biomass, in kg.}
\item{bole}{Stem, or bole, biomass, in kg.}
\item{bark}{Bark biomass, in kg.}
\item{total}{Total biomass, in kg.}
}
}
\source{
The data were provided courtesy of Dr Timothy Gregoire, Yale University,
in New Haven, CT, USA.
}
\usage{
data(maple)
}
\description{
These are tree-level measurement data of sample trees in the US.
}
\examples{
data(maple)    
head(maple) 
plot(total~dbh,data=maple)
}
\references{
\itemize{
\item Prof. Christian Salas-Eljatib at Universidad de Chile, Santiago,
Chile.
}
}
\keyword{datasets}
