% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symm_fit_cor_rho.R
\name{symm_fit_cor_EM_rho}
\alias{symm_fit_cor_EM_rho}
\title{symm_fit_cor_rho.R}
\usage{
symm_fit_cor_EM_rho(
  testStats,
  initRho,
  initMuList,
  initPiList,
  eps = 10^(-5),
  checkpoint = TRUE
)
}
\arguments{
\item{testStats}{J*K matrix of test statistics where J is the number of sets and K is number of elements in each set.}

\item{initRho}{Initial value of rho, any reasonable guess should be ok.}

\item{initMuList}{List of 2^K elements where each element is a matrix with K rows and number of columns equal to the number of possible mean vectors for that binary group.}

\item{initPiList}{List of 2^K elements where each element is a vector with number of elements equal to the number of possible mean vectors for that binary group.}

\item{eps}{Scalar, stop the EM algorithm when L2 norm of difference in parameters is less than this value.}

\item{checkpoint}{Boolean, set to TRUE to print iterations of EM.}
}
\value{
A list with the elements:
\item{muInfo}{List with same dimensions as initMuList, holds the final mean parameters.}
\item{piInfo}{List with same dimensions as initPiList, holds the final probability parameters.}
\item{iter}{Number of iterations run in EM algorithm.}
\item{lfdrResults}{J*1 vector of all lfdr statistics.}
}
\description{
Fit the correlated csmGmm for sets of correlated elements. Also fits the correlation parameter in EM algorithm.
}
\examples{
set.seed(0)
corMat <- matrix(data=c(1, 0.3, 0.3, 1), nrow=2)
testStats <- rbind(mvtnorm::rmvnorm(n=200, mean=c(3, 0), sigma=corMat),
mvtnorm::rmvnorm(n=200, mean=c(0, 4), sigma=corMat),
mvtnorm::rmvnorm(n=100, mean=c(7, 7), sigma=corMat),
mvtnorm::rmvnorm(n=10^4 - 500, mean=c(0, 0), sigma=corMat))
initMuList <- list(matrix(data=0, nrow=2, ncol=1), matrix(data=c(0, 3), nrow=2),
matrix(data=c(4, 0), nrow=2), matrix(data=c(5, 5), nrow=2))
initPiList <- list(c(0.9), c(0.04), c(0.04), c(0.02))
results <- symm_fit_cor_EM_rho(testStats = testStats,
initRho = 0.1, initMuList = initMuList, initPiList = initPiList)

}
