% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_model.R
\name{h_model_dual_endpoint_sigma2w}
\alias{h_model_dual_endpoint_sigma2w}
\title{Update \code{\link{DualEndpoint}} class model components with regard to biomarker
regression variance.}
\usage{
h_model_dual_endpoint_sigma2w(use_fixed, sigma2W, comp)
}
\arguments{
\item{use_fixed}{(\code{flag})\cr indicates whether a fixed value for the biomarker
regression variance \code{sigma2W} should be used or not. If \code{sigma2W} is not
supposed to be a fixed value, a prior distribution from the Inverse-Gamma
distribution will be used. See the details below, under \code{sigma2W} argument.}

\item{sigma2W}{(\code{numeric})\cr the biomarker variance. Either a fixed value or
Inverse-Gamma distribution parameters, i.e. vector with two elements named
\code{a} and \code{b}.}

\item{comp}{(\code{list})\cr a named list with model components that will be updated.
The names should be: \code{priormodel}, \code{modelspecs}, \code{init}, \code{sample}. For
definitions of the components, see \code{\link{GeneralModel}} class.
The \code{modelspecs} and \code{init} components on \code{comp} list are specified up to
the body of corresponding \code{GeneralModel@modelspecs} and \code{GeneralModel@init}
functions. These bodies are simply a lists itself.}
}
\value{
\code{list} with updated model components.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A simple helper function that takes \code{\link{DualEndpoint}} model existing components
(\code{priormodel}, \code{modelspecs}, \code{init}, \code{sample}), and updates them with regard to
to biomarker regression variance \code{sigma2W}.
}
