% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{IncrementsDoseLevels-class}
\alias{IncrementsDoseLevels-class}
\alias{.IncrementsDoseLevels}
\alias{IncrementsDoseLevels}
\alias{.DefaultIncrementsDoseLevels}
\title{\code{IncrementsDoseLevels}}
\usage{
IncrementsDoseLevels(levels = 1L, basis_level = "last")

.DefaultIncrementsDoseLevels()
}
\arguments{
\item{levels}{(\code{count})\cr see slot definition.}

\item{basis_level}{(\code{string})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{IncrementsDoseLevels}} is the class for increments control based on the
number of dose levels.
}
\section{Slots}{

\describe{
\item{\code{levels}}{(\code{count})\cr maximum number of dose levels to increment for
the next dose. It defaults to 1, which means that no dose skipping is
allowed, i.e. the next dose can be maximum one level higher than the current
base dose. The current base dose level is the dose level used to increment
from (see \code{basis_level} parameter).}

\item{\code{basis_level}}{(\code{string})\cr defines the current base dose level. It can
take one out of two possible values: \code{last} or \code{max}.
If \code{last} is specified (default), the current base dose level is set to the
last dose given. If \code{max} is specified, then the current base dose level is
set to the maximum dose level given.}
}}

\note{
Typically, end users will not use the \code{.DefaultIncrementsDoseLevels()} function.
}
\examples{
# The rule for dose increments which allows for maximum skip one dose level,
# that is 2 dose levels higher than the last dose given.
my_increments <- IncrementsDoseLevels(levels = 2, basis_level = "last")
}
