% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spearman_correlation_coefficient_rxc_bca.R
\name{Spearman_correlation_coefficient_rxc_bca}
\alias{Spearman_correlation_coefficient_rxc_bca}
\title{The Spearman correlation coefficient with the bias-corrected and accelerated}
\usage{
Spearman_correlation_coefficient_rxc_bca(n, nboot = 10000, alpha = 0.05)
}
\arguments{
\item{n}{the observed table (an rxc matrix)}

\item{nboot}{number of bootstrap samples}

\item{alpha}{the nominal significance level, used to compute a 100(1-alpha) confidence interval}
}
\value{
An object of the \link{contingencytables_result} class,
basically a subclass of \code{\link[base:list]{base::list()}}. Use the \code{\link[utils:str]{utils::str()}} function
to see the specific elements returned.
}
\description{
The Spearman correlation coefficient with the bias-corrected and accelerated

boostrap confidence interval

Described in Chapter 7 "The rxc Table"
}
\examples{
set.seed(2921)
Spearman_correlation_coefficient_rxc_bca(table_7.7, nboot = 800)
Spearman_correlation_coefficient_rxc_bca(table_7.8, nboot = 200)
\dontrun{
  Spearman_correlation_coefficient_rxc_bca(table_7.9)
}
}
