% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_arg_max_vif.R
\name{validate_arg_max_vif}
\alias{validate_arg_max_vif}
\title{Check and constrain argument \code{max_vif}}
\usage{
validate_arg_max_vif(max_vif = NULL, quiet = FALSE, function_name = NULL)
}
\arguments{
\item{max_vif}{(optional, numeric or NULL) Maximum Variance Inflation Factor allowed for \code{predictors} during multicollinearity filtering. Recommended values are between 2.5 (strict) and 10 (permissive). Default: 5}

\item{quiet}{(optional; logical) If FALSE, messages are printed. Default: FALSE.}

\item{function_name}{(optional, character string) Name of the function performing the argument check. Default: NULL}
}
\value{
numeric or NULL
}
\description{
Check and constrain argument \code{max_vif}
}
\examples{
max_vif <- validate_arg_max_vif(
  max_vif = 11, #wrong value
  quiet = FALSE
)

max_vif
attributes(max_vif)$validated
}
\seealso{
Other argument_validation: 
\code{\link{drop_geometry_column}()},
\code{\link{validate_arg_df}()},
\code{\link{validate_arg_df_not_null}()},
\code{\link{validate_arg_encoding_method}()},
\code{\link{validate_arg_f}()},
\code{\link{validate_arg_function_name}()},
\code{\link{validate_arg_max_cor}()},
\code{\link{validate_arg_predictors}()},
\code{\link{validate_arg_preference_order}()},
\code{\link{validate_arg_quiet}()},
\code{\link{validate_arg_responses}()}
}
\concept{argument_validation}
