\name{peg_pain_scale}
\alias{peg_pain_scale}
\title{
PEG Scale (Pain, Enjoyment, General Activity)
}
\description{
Calculates the PEG Score, a 3-item scale used to assess chronic pain intensity and interference. It is derived from the Brief Pain Inventory (BPI) and asks patients to rate average pain, interference with enjoyment of life, and interference with general activity over the past week on a scale of 0-10.
}
\usage{
peg_pain_scale(pain_average, enjoyment_of_life, general_activity)
}
\arguments{
  \item{pain_average}{
Numeric (0-10). What number best describes your pain on average in the past week? (0 = No pain, 10 = Pain as bad as you can imagine).
}
  \item{enjoyment_of_life}{
Numeric (0-10). What number describes how, during the past week, pain has interfered with your enjoyment of life? (0 = Does not interfere, 10 = Completely interferes).
}
  \item{general_activity}{
Numeric (0-10). What number describes how, during the past week, pain has interfered with your general activity? (0 = Does not interfere, 10 = Completely interferes).
}
}
\value{
A list containing:
\item{PEG_Score}{The calculated score (mean of the 3 items, Range 0-10).}
\item{Interpretation}{Clinical interpretation of pain impact severity.}
}
\references{
Krebs EE, Lorenz KA, Bair MJ, et al. Development and initial validation of the PEG, a three-item scale assessing pain intensity and interference. J Gen Intern Med. 2009;24(6):733-738. doi:10.1007/s11606-009-0981-1
}
\examples{

# Example 1: Severe Impact
# Pain 8, Enjoyment 9, Activity 7
# Score = (8+9+7)/3 = 8.0
peg_pain_scale(8, 9, 7)

# Example 2: Mild Impact
# Pain 2, Enjoyment 1, Activity 0
# Score = 1.0
peg_pain_scale(2, 1, 0)
}
