\name{galad_score_hcc}
\alias{galad_score_hcc}
\title{
GALAD Model for Hepatocellular Carcinoma (HCC)
}
\description{
Calculates the GALAD score (Gender, Age, AFP-L3, AFP, DCP) to estimate the probability of Hepatocellular Carcinoma (HCC) in patients with chronic liver disease. This serum biomarker-based model demonstrates high sensitivity and specificity for detecting early-stage HCC, often outperforming AFP alone.
}
\usage{
galad_score_hcc(sex, age, afp, afp_l3, dcp)
}
\arguments{
  \item{sex}{
String. Patient sex ("Male" or "Female"). (Male adds 1.67 to the Z-score).
}
  \item{age}{
Numeric. Patient age in years.
}
  \item{afp}{
Numeric. Alpha-fetoprotein level in ng/mL.
}
  \item{afp_l3}{
Numeric. Lens culinaris agglutinin-reactive fraction of AFP in percentage (\%).
}
  \item{dcp}{
Numeric. Des-gamma-carboxy prothrombin level in ng/mL.
}
}
\value{
A list containing:
\item{GALAD_Score_Z}{The linear predictor score (Z).}
\item{Probability_HCC}{The estimated probability of having HCC.}
\item{Risk_Category}{Assessment based on standard cutoffs (e.g., Z > -0.63 suggests higher risk).}
}
\references{
Johnson PJ, Pirrie SJ, Cox TF, et al. The detection of hepatocellular carcinoma using a prospectively developed and validated model based on serological biomarkers. Cancer Epidemiol Biomarkers Prev. 2014;23(1):144-153. doi:10.1158/1055-9965.EPI-13-0870
}
\examples{

# Example 1: High Risk
# 65yo Male, AFP 10 ng/mL, AFP-L3 5\%, DCP 20 ng/mL
# Z-score approx 1.3 -> High Probability (~79\%)
galad_score_hcc("male", 65, 10, 5, 20)

# Example 2: Low Risk
# 40yo Female, AFP 3 ng/mL, AFP-L3 1\%, DCP 5 ng/mL
# Z-score approx -4.5 -> Low Probability (<2\%)
galad_score_hcc("female", 40, 3, 1, 5)
}
