\name{forrest_classification}
\alias{forrest_classification}
\title{
Forrest Classification for Upper GI Bleeding
}
\description{
Retrieves the Forrest Classification, associated rebleeding risk, and management recommendations for patients with upper gastrointestinal hemorrhage based on endoscopic findings. This system is used to stratify high-risk lesions requiring endoscopic intervention from low-risk lesions suitable for standard medical therapy or early discharge.
}
\usage{
forrest_classification(endoscopic_finding)
}
\arguments{
  \item{endoscopic_finding}{
String. The specific finding observed during endoscopy.
Options:
"spurting_hemorrhage" (Active pulsatile bleeding).
"oozing_hemorrhage" (Active non-pulsatile bleeding).
"visible_vessel" (Non-bleeding visible vessel).
"adherent_clot" (Adherent clot).
"flat_pigmented_spot" (Flat pigmented spot/hematin).
"clean_base" (Clean ulcer base).
}
}
\value{
A list containing:
\item{Forrest_Class}{The classification grade (Ia, Ib, IIa, IIb, IIc, or III).}
\item{Risk_of_Rebleeding}{Estimated probability of rebleeding if untreated.}
\item{Mortality_Risk}{Estimated mortality risk.}
\item{Management_Recommendation}{Guidance on the need for endoscopic hemostasis.}
}
\references{
Forrest JA, Finlayson ND, Shearman DJ. Endoscopy in gastrointestinal bleeding. Lancet. 1974;2(7877):394-397. doi:10.1016/s0140-6736(74)91770-x
}
\examples{

# Example 1: High Risk
# Active spurting bleeding
forrest_classification("spurting_hemorrhage")

# Example 2: Low Risk
# Clean ulcer base
forrest_classification("clean_base")
}
