\name{findrisc_score}
\alias{findrisc_score}
\title{
FINDRISC (Finnish Diabetes Risk Score)
}
\description{
Calculates the FINDRISC score to estimate the 10-year risk of developing Type 2 Diabetes. This screening tool identifies individuals at high risk who may benefit from lifestyle interventions or further diagnostic testing.
}
\usage{
findrisc_score(age, bmi, waist_cm, sex, physical_activity,
               vegetables_fruit_daily, bp_meds, high_glucose_history,
               family_history)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
<45: 0 pts.
45-54: 2 pts.
55-64: 3 pts.
>64: 4 pts.
}
  \item{bmi}{
Numeric. Body Mass Index (kg/m^2).
<25: 0 pts.
25-30: 1 pt.
>30: 3 pts.
}
  \item{waist_cm}{
Numeric. Waist circumference in centimeters.
Male: <94 (0), 94-102 (3), >102 (4).
Female: <80 (0), 80-88 (3), >88 (4).
}
  \item{sex}{
String. "male" or "female". Used to determine waist circumference thresholds.
}
  \item{physical_activity}{
Numeric (0 or 1). Do you usually have at least 30 minutes of physical activity at work and/or leisure time? (1 = Yes, 0 pts; 0 = No, 2 pts).
}
  \item{vegetables_fruit_daily}{
Numeric (0 or 1). How often do you eat vegetables, fruit, or berries? (1 = Every day, 0 pts; 0 = Not every day, 1 pt).
}
  \item{bp_meds}{
Numeric (0 or 1). Have you ever taken medication for high blood pressure? (1 = Yes, 2 pts; 0 = No, 0 pts).
}
  \item{high_glucose_history}{
Numeric (0 or 1). Have you ever been found to have high blood glucose (e.g., in a health exam, during illness, during pregnancy)? (1 = Yes, 5 pts; 0 = No, 0 pts).
}
  \item{family_history}{
String. Have any members of your immediate family or other relatives been diagnosed with diabetes?
"none": No (0 pts).
"2nd_degree": Yes, grandparent, aunt, uncle, or first cousin (3 pts).
"1st_degree": Yes, parent, brother, sister, or own child (5 pts).
}
}
\value{
A list containing:
\item{FINDRISC_Score}{The calculated total risk score (Range 0-26).}
\item{Risk_Level}{Classification (Low, Slightly Elevated, Moderate, High, Very High).}
\item{Ten_Year_Diabetes_Risk}{Estimated percentage probability of developing Type 2 Diabetes within 10 years.}
}
\references{
Lindström J, Tuomilehto J. The diabetes risk score: a practical tool to predict type 2 diabetes risk. Diabetes Care. 2003;26(3):725-731. doi:10.2337/diacare.26.3.725
}
\examples{

# Example 1: High Risk
# 60yo (+3), BMI 32 (+3), Waist 110 (Male, +4), No Activity (+2), 1st Degree Fam (+5)
# Score = 17
findrisc_score(60, 32, 110, "male", 0, 1, 0, 0, "1st_degree")

# Example 2: Low Risk
# 35yo (0), BMI 22 (0), Waist 70 (Female, 0), Active (0), Daily Veg (0), No Hx
# Score = 0
findrisc_score(35, 22, 70, "female", 1, 1, 0, 0, "none")
}
