\name{denver_hiv_risk_score}
\alias{denver_hiv_risk_score}
\title{
Denver HIV Risk Score
}
\description{
Calculates the Denver HIV Risk Score to categorize patients into risk groups for HIV infection. This tool helps target HIV screening resources by identifying individuals with a higher pre-test probability of infection. The scoring algorithm differs for men and women.
}
\usage{
denver_hiv_risk_score(age, sex, msm, injection_drug_use,
                      vaginal_anal_sex_no_condom, std_history)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{msm}{
Numeric (0 or 1). For males: Sex with men? (1 = Yes).
}
  \item{injection_drug_use}{
Numeric (0 or 1). Injection drug use? (1 = Yes).
}
  \item{vaginal_anal_sex_no_condom}{
Numeric (0 or 1). Vaginal or anal sex without a condom? (1 = Yes).
}
  \item{std_history}{
Numeric (0 or 1). For females: History of sexually transmitted disease? (1 = Yes).
}
}
\value{
A list containing:
\item{Denver_Score}{The calculated risk score (Range 0-~80 depending on combinations).}
\item{Risk_Category}{Classification (Low <20, Moderate 20-29, High 30-39, Very High 40-49, Extremely High >=50).}
\item{Estimated_Prevalence}{Estimated prevalence of undiagnosed HIV in this risk group.}
}
\references{
Haukoos JS, Hopkins E, Bender B, et al. Comparison of enhanced targeted rapid HIV screening using the Denver HIV Risk Score to nontargeted rapid HIV screening in the emergency department. Ann Emerg Med. 2013;61(3):353-361. doi:10.1016/j.annemergmed.2012.11.002
}
\examples{

# Example 1: High Risk Male
# 35yo (+14), MSM (+18), Unprotected Sex (+12)
# Score = 44 (Very High Risk)
denver_hiv_risk_score(35, "male", 1, 0, 1, 0)

# Example 2: Moderate Risk Female
# 25yo (+3), IVDU (+21)
# Score = 24 (Moderate Risk)
denver_hiv_risk_score(25, "female", 0, 1, 0, 0)
}
