\name{ckid_u25_egfr}
\alias{ckid_u25_egfr}
\title{
CKiD U25 eGFR Calculator (Bedside Schwartz)
}
\description{
Calculates the estimated Glomerular Filtration Rate (eGFR) for children and young adults (ages 1-25) using the CKiD U25 equation. This equation is mathematically identical to the "Bedside Schwartz" (2009) formula but has been validated for use in young adults up to age 25.
}
\usage{
ckid_u25_egfr(height_cm, creatinine, creatinine_units = "mg/dL")
}
\arguments{
  \item{height_cm}{
Numeric. Patient height in centimeters.
}
  \item{creatinine}{
Numeric. Serum creatinine level.
}
  \item{creatinine_units}{
String. Units for creatinine. Options: "mg/dL" (default), "micromol/L", or "umol/L".
}
}
\value{
A list containing:
\item{eGFR_mL_min_1_73m2}{The estimated GFR normalized to 1.73 m^2 body surface area.}
\item{Method}{Description of the formula used (k = 0.413).}
}
\references{
Pierce CB, Muñoz A, Ng DK, et al. Age- and Sex-Dependent Clinical Equations to Estimate GFR in Children and Young Adults with CKD. Clin J Am Soc Nephrol. 2021;16(6):871-880. doi:10.2215/CJN.17191120
Schwartz GJ, Muñoz A, Schneider MF, et al. New equations to estimate GFR in children with CKD. J Am Soc Nephrol. 2009;20(3):629-637. doi:10.1681/ASN.2008030287
}
\examples{

# Example 1: Child
# 120 cm, Cr 0.6 mg/dL
# eGFR = 0.413 * (120 / 0.6) = 82.6
ckid_u25_egfr(120, 0.6)

# Example 2: Young Adult (SI Units)
# 175 cm, Cr 88.4 umol/L (1.0 mg/dL)
# eGFR = 0.413 * (175 / 1.0) = 72.3
ckid_u25_egfr(175, 88.4, "umol/L")
}
