\name{cardiac_power_output}
\alias{cardiac_power_output}
\title{
Cardiac Power Output (CPO)
}
\description{
Calculates Cardiac Power Output (CPO), a hemodynamic metric that integrates both pressure and flow (Cardiac Output x Mean Arterial Pressure) to assess the pumping ability of the heart. Measured in Watts, it is a potent predictor of mortality in patients with cardiogenic shock.
}
\usage{
cardiac_power_output(mean_arterial_pressure, cardiac_output)
}
\arguments{
  \item{mean_arterial_pressure}{
Numeric. Mean Arterial Pressure (MAP) in mmHg.
}
  \item{cardiac_output}{
Numeric. Cardiac Output in L/min.
}
}
\value{
A list containing:
\item{CPO_Watts}{The calculated Cardiac Power Output in Watts.}
\item{Interpretation}{Prognostic interpretation based on the critical threshold of 0.6 Watts derived from the SHOCK trial registry.}
}
\references{
Fincke R, Hochman JS, Lowe AM, et al. Cardiac power is the strongest hemodynamic correlate of mortality in cardiogenic shock: a report from the SHOCK Trial Registry. J Am Coll Cardiol. 2004;44(2):340-348. doi:10.1016/j.jacc.2004.03.060
}
\examples{

# Example 1: Cardiogenic Shock (Poor Prognosis)
# MAP 60 mmHg, CO 3.0 L/min
# CPO = (60 * 3.0) / 451 = 0.40 W
cardiac_power_output(60, 3.0)

# Example 2: Improved Hemodynamics
# MAP 75 mmHg, CO 4.5 L/min
# CPO = (75 * 4.5) / 451 = 0.75 W
cardiac_power_output(75, 4.5)
}
