\name{calculate_anion_gap}
\alias{calculate_anion_gap}
\title{
Serum Anion Gap
}
\description{
Calculates the Serum Anion Gap (AG) to evaluate metabolic acidosis. The Anion Gap represents the difference between measured cations (Sodium) and measured anions (Chloride and Bicarbonate). An optional calculation for the Albumin-Corrected Anion Gap is included, which adjusts for hypoalbuminemia, a common cause of a falsely low anion gap.
}
\usage{
calculate_anion_gap(sodium, chloride, bicarbonate, albumin = NULL)
}
\arguments{
  \item{sodium}{
Numeric. Serum Sodium level in mEq/L or mmol/L.
}
  \item{chloride}{
Numeric. Serum Chloride level in mEq/L or mmol/L.
}
  \item{bicarbonate}{
Numeric. Serum Bicarbonate (or total CO2) level in mEq/L or mmol/L.
}
  \item{albumin}{
Numeric (Optional). Serum Albumin level in g/dL. Used to calculate the Corrected Anion Gap.
}
}
\details{
The basic formula is:
\deqn{AG = Na - (Cl + HCO3)}
The Albumin-Corrected Anion Gap formula is:
\deqn{Corrected AG = AG + (2.5 \times (4.4 - Albumin))}
Normal Anion Gap range is typically considered 4-12 mEq/L, though this varies by laboratory assay.
}
\value{
A list containing:
\item{Anion_Gap}{The calculated Anion Gap.}
\item{Corrected_Anion_Gap}{The Anion Gap adjusted for albumin level (if albumin is provided).}
}
\references{
Emmett M, Narins RG. Clinical use of the anion gap. Medicine (Baltimore). 1977;56(1):38-54.
Figge J, Jabor A, Kazda A, Fencl V. Anion gap and hypoalbuminemia. Crit Care Med. 1998;26(11):1807-1810.
}
\examples{
calculate_anion_gap(sodium = 140, chloride = 100, bicarbonate = 24)

calculate_anion_gap(sodium = 140, chloride = 100, bicarbonate = 24, albumin = 2.5)
}
