\name{ausdrisk_score}
\alias{ausdrisk_score}
\title{
Australian Type 2 Diabetes Risk Assessment Tool (AUSDRISK)
}
\description{
Calculates the AUSDRISK score to estimate the 5-year risk of developing Type 2 Diabetes. This tool is designed for use in the general Australian adult population. It evaluates demographic, lifestyle, and anthropometric risk factors.
}
\usage{
ausdrisk_score(age, sex, ethnicity_high_risk, family_history,
               high_glucose_history, bp_meds, smoker, fruit_veg_daily,
               physical_activity_sufficient, waist_cm)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{sex}{
String. Patient sex ("Male" or "Female"). (Male adds +3 points).
}
  \item{ethnicity_high_risk}{
Numeric (0 or 1). Is the patient of Aboriginal, Torres Strait Islander, Pacific Islander, Southern European, or Asian background? (1 = Yes, +2 points).
}
  \item{family_history}{
Numeric (0 or 1). History of diabetes in a parent, brother, or sister. (1 = Yes, +3 points).
}
  \item{high_glucose_history}{
Numeric (0 or 1). History of high blood glucose levels (e.g., during pregnancy or borderline check). (1 = Yes, +6 points).
}
  \item{bp_meds}{
Numeric (0 or 1). Current use of blood pressure medication. (1 = Yes, +2 points).
}
  \item{smoker}{
Numeric (0 or 1). Current smoker. (1 = Yes, +2 points).
}
  \item{fruit_veg_daily}{
Numeric (0 or 1). Consumes fruit and vegetables every day. (1 = Yes, 0 points; 0 = No, +1 point).
}
  \item{physical_activity_sufficient}{
Numeric (0 or 1). Engages in at least 2.5 hours of physical activity per week. (1 = Yes, 0 points; 0 = No, +2 points).
}
  \item{waist_cm}{
Numeric. Waist circumference in centimeters.
Male: 90-100 cm (+4), >100 cm (+7).
Female: 80-90 cm (+4), >90 cm (+7).
}
}
\value{
A list containing:
\item{AUSDRISK_Score}{The calculated total risk score.}
\item{Risk_Level}{Classification (Low: <=5, Intermediate: 6-11, High: >=12).}
\item{Probability_5_Year}{Estimated probability description.}
}
\references{
Department of Health and Aged Care. The Australian Type 2 Diabetes Risk Assessment Tool (AUSDRISK). Australian Government. 2008.
}
\examples{

# Example 1: High Risk
# 50yo Male (+7), Asian (+2), FamHx (+3), No Activity (+2), Waist 95 (+4)
# Score = 4 (Age) + 3 (Sex) + 2 (Eth) + 3 (Fam) + 2 (Act) + 4 (Waist) = 18
ausdrisk_score(50, "male", 1, 1, 0, 0, 0, 1, 0, 95)

# Example 2: Low Risk
# 30yo Female, No risk factors
# Score = 0
ausdrisk_score(30, "female", 0, 0, 0, 0, 0, 1, 1, 70)
}
