\name{abcd2_tia}
\alias{abcd2_tia}
\title{
ABCD2 Score for TIA
}
\description{
Calculates the ABCD2 Score to estimate the risk of stroke within 2, 7, and 90 days after a Transient Ischemic Attack (TIA). This score is widely used to determine the urgency of evaluation and the need for hospital admission.
}
\usage{
abcd2_tia(age, bp_systolic, bp_diastolic, clinical_features, duration_min, diabetes)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (+1 point if >= 60).
}
  \item{bp_systolic}{
Numeric. Initial systolic blood pressure in mmHg. (+1 point if >= 140 or DBP >= 90).
}
  \item{bp_diastolic}{
Numeric. Initial diastolic blood pressure in mmHg. (+1 point if >= 90 or SBP >= 140).
}
  \item{clinical_features}{
Numeric (0, 1, or 2). Description of symptoms.
2: Unilateral weakness (+2 points).
1: Speech disturbance without weakness (+1 point).
0: Other symptoms (+0 points).
}
  \item{duration_min}{
Numeric. Duration of symptoms in minutes.
>= 60 minutes (+2 points).
10-59 minutes (+1 point).
< 10 minutes (0 points).
}
  \item{diabetes}{
Numeric (0 or 1). History of diabetes mellitus (oral medication or insulin).
1: Yes (+1 point).
0: No (0 points).
}
}
\value{
A list containing:
\item{Score}{Total ABCD2 Score (Range 0-7).}
\item{Risk_Category}{Risk classification (Low, Moderate, High).}
\item{Stroke_Risk}{List of estimated stroke risks at 2, 7, and 90 days.}
\item{Management}{Recommendation regarding hospital admission.}
}
\references{
Johnston SC, Rothwell PM, Nguyen-Huynh MN, et al. Validation and refinement of scores to predict very early stroke risk after transient ischaemic attack. Lancet. 2007;369(9558):283-92. doi:10.1016/S0140-6736(07)60150-0
}
\examples{

# Example 1: High Risk
# 65yo, BP 150/90, Unilateral weakness, Duration 45 mins, Diabetes
# Age(1) + BP(1) + Weakness(2) + Duration(1) + Diabetes(1) = 6
abcd2_tia(65, 150, 90, 2, 45, 1)

# Example 2: Low Risk
# 45yo, BP 120/80, Speech disturbance only, Duration 5 mins, No Diabetes
# Age(0) + BP(0) + Speech(1) + Duration(0) + Diabetes(0) = 1
abcd2_tia(45, 120, 80, 1, 5, 0)
}
