\name{abbreviated_mental_test_4}
\alias{abbreviated_mental_test_4}
\title{
Abbreviated Mental Test 4 (AMT-4)
}
\description{
Calculates the AMT-4 score, a rapid screening tool for cognitive impairment derived from the longer AMT-10. It assesses four specific domains: Age, Date of Birth, Place, and Year. A score of less than 4 indicates possible cognitive impairment.
}
\usage{
abbreviated_mental_test_4(age_correct, dob_correct, place_correct, year_correct)
}
\arguments{
  \item{age_correct}{
Numeric (0 or 1). Correctly states own age.
}
  \item{dob_correct}{
Numeric (0 or 1). Correctly states date of birth.
}
  \item{place_correct}{
Numeric (0 or 1). Correctly states the name of the place (e.g., hospital name or address).
}
  \item{year_correct}{
Numeric (0 or 1). Correctly states the current year.
}
}
\value{
A list containing:
\item{Total_Score}{Sum of the correct answers (Range 0-4).}
\item{Interpretation}{Clinical suggestion based on the score (Normal = 4, Abnormal < 4).}
}
\references{
Swain DG, Nightingale PG. Evaluation of a shortened version of the Abbreviated Mental Test in a series of elderly patients. Clin Rehabil. 1997;11(3):243-248. doi:10.1177/026921559701100311
}
\examples{

# Example 1: Normal Cognition
# All answers correct
abbreviated_mental_test_4(1, 1, 1, 1)

# Example 2: Possible Impairment
# Incorrect year
abbreviated_mental_test_4(1, 1, 1, 0)
}
