% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_cld.R
\name{as_cld}
\alias{as_cld}
\alias{as_cld.data.frame}
\alias{as_cld.character}
\alias{as_cld.cld_object}
\title{Convert objects to cld_object}
\usage{
as_cld(x, ...)

\method{as_cld}{data.frame}(x, ...)

\method{as_cld}{character}(x, ...)

\method{as_cld}{cld_object}(x, ...)
}
\arguments{
\item{x}{Object to convert to \code{cld_object}}

\item{...}{Additional arguments passed to methods}
}
\value{
A \code{cld_object} (data frame with class \code{c("cld_object", "data.frame")})
containing three columns:
\itemize{
\item \code{group} - Character. The names of the groups
\item \code{cld} - Character. The compact letter display for each group
\item \code{spaced_cld} - Character. A monospaced version of the CLD where spaces are
replaced with underscores, useful for maintaining alignment in output
}
}
\description{
Generic function to convert various objects to \code{cld_object} format.
This is useful when you have CLD results from other packages or
custom formats and want to use them with cld's methods.
}
\details{
The \code{as_cld()} function provides a way to convert various formats to
the standard \code{cld_object} structure. This is particularly useful when:
\itemize{
\item Working with CLD results from other packages
\item Converting custom formats to use cld's print and coercion methods
\item Creating CLD objects programmatically
}
}
\examples{
# Convert from data frame
df <- data.frame(
  group = c("A", "B", "C"),
  cld = c("a", "b", "b")
)
as_cld(df)

# Convert from named character vector
letters_vec <- c(A = "a", B = "b", C = "b")
as_cld(letters_vec)
}
\seealso{
\itemize{
\item \code{\link[=make_cld]{make_cld()}} for creating compact letter displays
\item \code{\link[=pval_matrix_to_df]{pval_matrix_to_df()}} for converting p-value matrices
\item \link{cld_methods} for other cld_object methods
}

Other helper functions: 
\code{\link{pval_matrix_to_df}()}

Other data conversion functions: 
\code{\link{pval_matrix_to_df}()}
}
\concept{data conversion functions}
\concept{data_conversion}
\concept{helper functions}
\concept{helper_functions}
\keyword{manip}
