% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{agree_cat}
\alias{agree_cat}
\title{Agreeableness Cat Object}
\format{
An object of class \code{Cat} of length 1.
}
\source{
See \code{https://dataverse.harvard.edu/dataverse/pdsl} for the raw YouGov and/or Qualtrics data.
}
\usage{
data(agree_cat)
}
\description{
Cat object containing item parameters for graded response model fit with responses to the 20-item Agreeableness dimension of the 
100-item IPIP representation of Costa and McCrae's Five Factor Model
}
\details{
Cat object containing item parameters for graded response model fit with 774,410 response profiles by myPersonality Poject and 1500 response profiles
collected by YouGov in June 2018.  The sample from myPersonality Project was a convenience sample, and the
respondents from YouGov were matched to a sampling frame on gender, age, race, and education.


See \code{\link{Cat-class}} for details regarding the Cat object structure.
See \code{\link{grmCat}} for details regarding the graded response model. 

A normal prior was chosen with mean from the theta estimates from the YouGov sample (.113) and a standard deviation (1.5)
wide enough to envelope the range of estimated theta values across both samples.

Note that due to how the item parameters were estimated, large, positive values indicate "more" of the latent trait.

Response options are 1=Very inaccurate; 2=Moderately inaccurate; 3=Neither inaccurate nor accurate;
4=Moderately accurate; 5=Very accurate.

The wording of the question items:

I...
\describe{
\item{\code{q86}}{Have a good word for everyone.}
\item{\code{q6}}{Believe that others have good intentions.}
\item{\code{q66}}{Respect others.}
\item{\code{q46}}{Accept people as they are.}
\item{\code{q36}}{Make people feel at ease.}
\item{\code{q26}}{Am concerned about others.}
\item{\code{q56}}{Trust what people say.}
\item{\code{q76}}{Sympathize with others' feelings.}
\item{\code{q13}}{Am easy to satisfy.}
\item{\code{q96}}{Treat all people equally.}
\item{\code{q82}}{Have a sharp tongue.}
\item{\code{q9}}{Cut others to pieces.}
\item{\code{q22}}{Suspect hidden motives in others.}
\item{\code{q32}}{Get back at others.}
\item{\code{q92}}{Insult people.}
\item{\code{q42}}{Believe that I am better than others.}
\item{\code{q52}}{Contradict others.}
\item{\code{q62}}{Make demands on others.}
\item{\code{q2}}{Hold a grudge.}
\item{\code{q72}}{Am out for my own personal gain.}
}
}
\references{
Costa, P. T., Jr., & McCrae, R. R. (1992). Revised NEO Personality Inventory (NEO PI-R)
and NEO Five-Factor Inventory (NEO-FFI): Professional manual. Odessa, FL: Psychological Assessment Resources.


Stillwell, David, and Michal Kosinski. 2007. "myPersonality Project."
\url{https://sites.google.com/michalkosinski.com/mypersonality}
}
\seealso{
\code{\link{Cat-class}}, \code{\link{grmCat}}
}
\keyword{datasets}
