% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_sdm.r
\name{prediction_change_sdm}
\alias{prediction_change_sdm}
\title{Prediction Change Analysis}
\usage{
prediction_change_sdm(i, scenario = NULL, ensemble_type = NULL, species = NULL, th = 0.5)
}
\arguments{
\item{i}{A \code{input_sdm} object with projections.}

\item{scenario}{Character. One of the scenarios that were projected. Can be ensembles as well.}

\item{ensemble_type}{Character. Type of ensemble to be used. Standard is NULL, but will return the mean_occ_prob}

\item{species}{Character. Species to be analyzed. Standard is NULL.}

\item{th}{Numeric. Threshold to binarize the ensemble.}
}
\value{
A plot with comparison between current and other scenario.
}
\description{
Provides an automate way for the visualization of projections gain, loss, and stability between different scenarios.
}
\examples{
# Create sdm_area object:
set.seed(1)
sa <- sdm_area(parana, cell_size = 100000, crs = 6933)

# Include predictors:
sa <- add_predictors(sa, bioc)

# Include scenarios:
sa <- add_scenarios(sa, scen) |> select_predictors(c("bio1", "bio12"))

# Create occurrences:
oc <- occurrences_sdm(occ, crs = 6933) |> join_area(sa)

# Create input_sdm:
i <- input_sdm(oc, sa)

# Pseudoabsence generation:
i <- pseudoabsences(i, method="random", n_set = 2)

# Custom trainControl:
ctrl_sdm <- caret::trainControl(method = "boot",
                                number = 1,
                                classProbs = TRUE,
                                returnResamp = "all",
                                summaryFunction = summary_sdm,
                                savePredictions = "all")

# Train models:
i <- train_sdm(i,
               algo = c("naive_bayes"),
               ctrl=ctrl_sdm,
               variables_selected = c("bio1", "bio12")) |>
  suppressWarnings()

# Predict models:
i  <- predict_sdm(i, th=0.8)

# Ensemble GCMs:
i <- gcms_ensembles(i, gcms = c("ca", "mi"))
i

# Change Analysis
prediction_change_sdm(i, scenario = "_ssp585_2090", ensemble_type = "mean_occ_prob")

}
\seealso{
\code{\link{species_names} \link{scenarios_names}}
}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
