% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_categorical_ci.R
\name{ard_categorical_ci}
\alias{ard_categorical_ci}
\alias{ard_categorical_ci.data.frame}
\title{ARD Proportion Confidence Intervals}
\usage{
ard_categorical_ci(data, ...)

\method{ard_categorical_ci}{data.frame}(
  data,
  variables,
  by = dplyr::group_vars(data),
  method = c("waldcc", "wald", "clopper-pearson", "wilson", "wilsoncc", "strat_wilson",
    "strat_wilsoncc", "agresti-coull", "jeffreys"),
  denominator = c("column", "row", "cell"),
  conf.level = 0.95,
  value = list(where(is_binary) ~ 1L, where(is.logical) ~ TRUE),
  strata = NULL,
  weights = NULL,
  max.iterations = 10,
  ...
)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame}

\item{...}{Arguments passed to methods.}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to include in summaries. Columns must be class \verb{<logical>}
or \verb{<numeric>} values coded as \code{c(0,1)}.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to stratify calculations by.}

\item{method}{(\code{string})\cr
string indicating the type of confidence interval to calculate.
Must be one of .
See \code{?proportion_ci} for details.}

\item{denominator}{(\code{string})\cr
Must be one of \code{'column'} (default), \code{'row'}, and \code{'cell'}, which specifies
the direction of the calculation/denominator. Argument is similar to
\code{cards::ard_tabulate(denominator)}.}

\item{conf.level}{(scalar \code{numeric})\cr
a scalar in \verb{(0,1)} indicating the confidence level.
Default is \code{0.95}}

\item{value}{(\code{\link[cards:syntax]{formula-list-selector}})\cr
function will calculate the CIs for all levels of the variables specified.
Use this argument to instead request only a single level by summarized.
Default is \code{list(where(is_binary) ~ 1L, where(is.logical) ~ TRUE)}, where
columns coded as \code{0}/\code{1} and \code{TRUE}/\code{FALSE} will summarize the \code{1} and \code{TRUE} levels.}

\item{strata, weights, max.iterations}{arguments passed to \code{proportion_ci_strat_wilson()},
when \code{method='strat_wilson'}}
}
\value{
an ARD data frame
}
\description{
Calculate confidence intervals for proportions.
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = "broom"))) withAutoprint(\{ # examplesIf}
# compute CI for binary variables
ard_categorical_ci(mtcars, variables = c(vs, am), method = "wilson")

# compute CIs for each level of a categorical variable
ard_categorical_ci(mtcars, variables = cyl, method = "jeffreys")
\dontshow{\}) # examplesIf}
}
