% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bundle.R
\name{bundle}
\alias{bundle}
\alias{unbundle}
\title{Bundling}
\usage{
bundle(x, ...)

unbundle(x)
}
\arguments{
\item{x}{A model object to bundle.}

\item{...}{Additional arguments to bundle methods.}
}
\value{
A bundle object with subclass referencing the modeling function. If a bundle method is not defined for the supplied object, \code{bundle.default} is the identity function.

Bundles are a list subclass with two components:

\item{object}{An R object. Gives the output of native serialization
methods from the model-supplying package, sometimes with additional
classes or attributes that aid portability. This is often
a \link[base:raw]{raw} object.}
\item{situate}{A function. The \code{situate()} function is defined when
\code{\link[=bundle]{bundle()}} is called, though is a loose analogue of an \code{\link[=unbundle]{unbundle()}} S3
method for that object. Since the function is defined on \code{\link[=bundle]{bundle()}}, it
has access to references and dependency information that can
be saved alongside the \code{object} component. Calling \code{\link[=unbundle]{unbundle()}} on a
bundled object \code{x} calls \code{x$situate(x$object)}, returning the
unserialized version of \code{object}. \code{situate()} will also restore needed
references, such as server instances and environmental variables.}

Bundles are R objects that represent a "standalone" version of their
analogous model object. Thus, bundles are ready for saving to a file; saving
with \code{\link[base:readRDS]{base::saveRDS()}} is our recommended serialization strategy for bundles,
unless documented otherwise for a specific method.

To restore the original model object \code{x} in a new environment, load its
bundle with \code{\link[base:readRDS]{base::readRDS()}} and run \code{\link[=unbundle]{unbundle()}} on it. The output
of \code{\link[=unbundle]{unbundle()}} is a model object that is ready to \code{\link[=predict]{predict()}} on new data,
and other restored functionality (like plotting or summarizing) is supported
as a side effect only.

The bundle package wraps native serialization methods from model-supplying
packages. Between versions, those model-supplying packages may change their
native serialization methods, possibly introducing problems with re-loading
objects serialized with previous package versions. The bundle package does
not provide checks for these sorts of changes, and ought to be used in
conjunction with tooling for managing and monitoring model environments
like \link[vetiver:vetiver-package]{vetiver} or \link[renv:renv-package]{renv}.

See \code{vignette("bundle")} for more information on bundling and its motivation.
}
\description{
\code{bundle()} methods provide a consistent interface to serialization
methods for statistical model objects. The created bundle can be saved,
then re-loaded and \code{unbundle()}d in a new R session for use in prediction.
}
\seealso{
Other bundlers: 
\code{\link{bundle.H2OAutoML}()},
\code{\link{bundle.bart}()},
\code{\link{bundle.keras.engine.training.Model}()},
\code{\link{bundle.luz_module_fitted}()},
\code{\link{bundle.model_fit}()},
\code{\link{bundle.model_stack}()},
\code{\link{bundle.recipe}()},
\code{\link{bundle.step_umap}()},
\code{\link{bundle.train}()},
\code{\link{bundle.workflow}()},
\code{\link{bundle.xgb.Booster}()}
}
\concept{bundlers}
