% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_brand_yml.R
\name{read_brand_yml}
\alias{read_brand_yml}
\title{Create a Brand instance from a Brand YAML file.}
\usage{
read_brand_yml(path = NULL)
}
\arguments{
\item{path}{The path to the brand.yml file or a directory where \verb{_brand.yml}
is expected to be found.}
}
\value{
A normalized \code{brand_yml} list from the brand.yml file.
}
\description{
Reads a Brand YAML file or finds and reads a \verb{_brand.yml} file and
returns a validated \code{Brand} instance.
}
\details{
By default, \code{read_brand_yml()} finds a project-specific \verb{_brand.yml} file, by
looking in the current working directory directory or any parent directory
for a \verb{_brand.yml}, \verb{brand/_brand.yml} or \verb{_brand/_brand.yml} file (or the
same variants with a \code{.yaml} extension). When \code{path} is provided,
\code{read_brand_yml()} looks for these files in the provided directory; for
automatic discovery, \code{read_brand_yml()} starts the search in the working
directory and moves upward to find the \verb{_brand.yml} file.
}
\examples{

# For this example: copy a brand.yml to a temporary directory
tmp_dir <- tempfile()
dir.create(tmp_dir)
file.copy(
  system.file("examples/brand-posit.yml", package = "brand.yml"),
  file.path(tmp_dir, "_brand.yml")
)

brand <- read_brand_yml(tmp_dir)

}
\references{
\url{https://posit-dev.github.io/brand-yml/}
}
