% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_forecast_performance.R
\name{compute_forecast_performance.ForecastsPANELpoos}
\alias{compute_forecast_performance.ForecastsPANELpoos}
\title{Computes forecasting performance measures for recursive 
pseudo-out-of-sample forecasts}
\usage{
\method{compute_forecast_performance}{ForecastsPANELpoos}(forecasts, measures = c("pls", "rmsfe", "mafe"))
}
\arguments{
\item{forecasts}{an object of class \code{ForecastsPANELpoos} containing the
outcome of Bayesian recursive pseudo-out-of-sample forecasting exercise
using expanding window samples generated using function 
\code{\link{forecast_poos_recursively}}.}

\item{measures}{a character vector with any of the values \code{"lps"},
\code{"rmsfe"}, \code{"mafe"} indicating the forecasting performance measures
to be computed.}
}
\value{
An object of class \code{ForecastingPerformance}
}
\description{
Computes forecasting performance measures selected from:
log-predictive score \code{"lps"}, root-mean-squared-forecast error \code{"rmsfe"}, 
mean-absolute-forecast error \code{"mafe"} from the output of the recursive 
pseudo-out-of-sample forecastinge exercise performed using function 
\code{\link{forecast_poos_recursively}}.
}
\examples{
spec = specify_bvarPANEL$new(ilo_dynamic_panel[1:5])               # specify the model
poos = specify_poosf_exercise$new(spec, 2, 5, 1, 30)    # specify the forecasting  exercise
fore = forecast_poos_recursively(spec, poos)                  # perform the forecasting  exercise
fp   = compute_forecast_performance(fore, "pls")   # compute forecasting performance measures

}
\seealso{
\code{\link{forecast_poos_recursively}}, 
\code{\link{forecast_poos_recursively.BVARPANEL}},
\code{\link{forecast_poos_recursively.BVARGROUPPANEL}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
