% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bp_preg}
\alias{bp_preg}
\title{Pregnancy Day Assessment Clinic Data}
\format{
A data frame containing 55 variables related to physiological assessment during pregnancy.
The data variable dictionary is as follows:
\describe{

\item{Abdominal.pain}{Binary indicator for whether an individual exhibits abdominal pain (1 = yes) or not (0 = no)}
\item{Accelerations}{Fetal heart rate accelerations}
\item{Admission}{Admission from PDAC}
\item{Age}{Maternal age at estimated date of confinement}
\item{ALP}{Alkaline phosphatase u/L}
\item{ALT}{Alanaine transaminase u/L}
\item{AN_PET}{Binary indicator for Antenatal diagnosis of pre-eclampsia 1 = yes, 0 = no}
\item{Antihypertensive.Meds}{Current antihypertensive medication}
\item{Asymptomatic}{Binary indicator for whether an individual is asymptomatic (1 = yes) or not (0 = no)}
\item{Baseline}{Baseline fetal heart rate (normal, bradycardia, tachycardia)}
\item{BMI}{Body Mass Index}
\item{Creatinine}{micromol/L}
\item{CTG}{Cardiotocogram}
\item{D_att_Dryad}{Date of attendance modified by adding a random number of days between -7 and +7}
\item{DBP}{Diastolic Blood Pressure}
\item{Decelerations}{Fetal heart rate decelerations}
\item{DOB_Dryad}{Maternal date of birth modified by adding a random number of days between -7 and +7}
\item{DrRV}{Medical review during PDAC}
\item{EDC_Dryad}{Estimated date of confinement modified by adding a random number of days between -7 and +7}
\item{EmCS}{Emergency Caesarean section}
\item{Final.Diagnosis.}{Final diagnosis: 0 = nil, 1 = pregnancy induced hypertension, 2 = pre-eclampsia}
\item{GA_att}{Gestational age (weeks) at attendance}
\item{GGT}{Gamma glutamyl transaminase u/L}
\item{Grav}{Gravidity: number of pregnancies including the current one}
\item{Headache}{Binary indicator for whether an individual has a headache (1 = yes) or not (0 = no)}
\item{Ht}{Maternal Height (cm)}
\item{Hyperreflexia}{Binary indicator for whether an individual exhibits Hyperreflexia (1 = yes) or not (0 = no)}
\item{IOL}{Induction of labour}
\item{ID}{Subject ID #}
\item{IP_PET}{Intrapartum diagnosis of pre-eclampsia 1 = yes, 0 = no}
\item{Nausea}{Binary indicator for whether an individual exhibits Nausea (1 = yes) or not (0 = no)}
\item{Oedema}{Binary indicator for whether an individual exhibits Oedema (1 = yes) or not (0 = no)}
\item{Para}{Parity: number of pregnancies proceding to 20 or more weeks, not including the current one}
\item{PHx_ASA}{Prescribed aspirin in this pregnancy}
\item{PHx_Eclampsia}{Past history of eclampsia}
\item{PHx_EssBP}{Past history of essential hypertension}
\item{PHx_PET}{Past history of pre-eclampsia}
\item{PHx_Smoker}{Smoking history}
\item{PIERS}{Pre-eclampsia Integrated Estimate of Risk (\%)}
\item{PN_PET}{Postnatal diagnosis of pre-eclampsia 1 = yes, 0 = no}
\item{Platelets}{10^9 per mL}
\item{PrevPDAC}{Number of previous PDAC assessments this pregnancy}
\item{Privacy}{Generic privacy consent form permits participation in audit}
\item{SBP}{Systolic Blood Pressure}
\item{SOB}{Binary indicator for whether an individual exhibits Shortness of Breath (SOB) (1 = yes) or not (0 = no)}
\item{Safe.for.discharge.at.1.hour.}{Binary indicator for whether an individual is safe for discharge at 1 hour
(1 = yes) or not (0 = no)}
\item{Safe.for.discharge.at.1.hour....Other..please.specify.}{Binary indicator for whether an individual is safe
for discharge at 1 hour - other - comments}
\item{Self.discharge}{Self-discharge from PDAC}
\item{Time_Elapsed}{30 minute recordings during the Pregnancy Day Assessment Clinic (PDAC) observation
window for up to a maximum of 240 minutes including the "Booking" recording}
\item{Urate}{mmol/L}
\item{Urea}{micromol/L}
\item{UrinePCR}{Spot urine protein:creatinine ratio mg/mmol}
\item{Variability}{Fetal heart rate variability as judged visually}
\item{Visual.Disturbances}{Binary indicator for whether an individual exhibits Visual Disturbances (1 = yes)
or not (0 = no)}
\item{Wt}{Pre-pregnancy or early pregnancy weight (kg)}

}
}
\source{
\doi{10.5061/dryad.0bq15}
}
\usage{
bp_preg
}
\description{
The \code{bp_preg} data set includes 209 women each with 30 minute recordings during the Pregnancy Day
Assessment Clinic (PDAC) observation window for up to a maximum of 240 minutes (i.e. a maximum
of 8 total readings per subject per observation window in addition to an initial "booking" reading
before the PDAC assessment). This recent study in obstetrics and gynecology investigated
pregnancy-induced hypertension (PIH) and pre-eclampsia (PE) prediction by analyzing cardiac and
physiological information to determine whether the blood pressure assessment of the first observation
window of 1 hour (60 minutes) was sufficient relative to the standard 4 hour (240 minute) window.
}
\details{
(McCarthy EA, Carins TA, Hannigan Y, Bardien N, Shub A, Walker S. 2015)

Licensed under a CC-0 1.0 (Creative Commons) Universal Public Domain Dedication License
}
\keyword{datasets}
