% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fp_utilities.R
\name{fp_utilities}
\alias{fp_utilities}
\alias{float_next}
\alias{float_prior}
\alias{float_distance}
\alias{float_advance}
\alias{ulp}
\alias{relative_difference}
\alias{epsilon_difference}
\title{Floating Point Utilities}
\usage{
float_next(x)

float_prior(x)

float_distance(x, y)

float_advance(x, distance)

ulp(x)

relative_difference(x, y)

epsilon_difference(x, y)
}
\arguments{
\item{x}{A numeric value.}

\item{y}{A numeric value.}

\item{distance}{Integer number of ULPS to advance by.}
}
\value{
A numeric value after performing the specified floating point operation.
}
\description{
Utilities for floating point number manipulation and analysis.
}
\examples{
print(float_next(1.0), digits = 20)
print(float_distance(1.0, 2.0), digits = 20)
print(float_prior(1.0), digits = 20)
print(float_advance(1.0, 10), digits = 20)
print(ulp(1.0), digits = 20)
print(relative_difference(1.1, 1.1000009), digits = 20)
print(epsilon_difference(1.1, 1.1000009), digits = 20)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/utils.html}{Boost Documentation} for more details on the mathematical background.
}
