% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls_analysis.R
\name{plot_pls_variables}
\alias{plot_pls_variables}
\title{Plot variable loadings}
\usage{
plot_pls_variables(
  object,
  comps = c(1L, 2L),
  circle = TRUE,
  circle_col = "grey80",
  arrow_col = "steelblue",
  arrow_scale = 1,
  ...
)
}
\arguments{
\item{object}{A fitted PLS model.}

\item{comps}{Components to display (length two).}

\item{circle}{Logical; draw the unit circle.}

\item{circle_col}{Colour of the unit circle.}

\item{arrow_col}{Colour of the variable arrows.}

\item{arrow_scale}{Scaling applied to variable vectors.}

\item{...}{Additional plotting parameters passed to \code{\link[graphics:plot.default]{graphics::plot()}}.}
}
\value{
Invisibly returns \code{NULL} after drawing the plot.
}
\description{
Plot variable loadings
}
\examples{
set.seed(123)
X <- matrix(rnorm(60), nrow = 20)
y <- X[, 1] - 0.5 * X[, 2] + rnorm(20, sd = 0.1)
fit <- pls_fit(X, y, ncomp = 2, scores = "r")
plot_pls_variables(fit)
}
