% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credential-azure-cli.R
\name{az_cli_account_show}
\alias{az_cli_account_show}
\title{Show Azure CLI Account Information}
\usage{
az_cli_account_show(timeout = 10L)
}
\arguments{
\item{timeout}{An integer specifying the timeout in seconds for the Azure
CLI command. Defaults to \code{10}.}
}
\value{
A list containing the account information from Azure CLI
}
\description{
Retrieves information about the currently active Azure CLI account and
subscription. This function runs \verb{az account show} and parses the JSON
output into an R list.
}
\details{
The function returns details about the current Azure subscription including:
\itemize{
\item Subscription ID and name
\item Tenant ID
\item Account state (e.g., "Enabled")
\item User information
\item Cloud environment details
}
}
\examples{
\dontrun{
# Get current account information
account_info <- az_cli_account_show()

# Access subscription ID
subscription_id <- account_info$id

# Access tenant ID
tenant_id <- account_info$tenantId
}

}
