% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_manynet.R
\name{map_member}
\alias{map_member}
\alias{plot.node_member}
\alias{plot.matrix}
\title{Plotting categorical memberships}
\usage{
\method{plot}{node_member}(x, ...)

\method{plot}{matrix}(x, ..., membership = NULL)
}
\arguments{
\item{x}{An object of "node_member" class, for example as a result of
running \code{manynet::node_in_community()}.}

\item{...}{Other arguments to be passed on.}

\item{membership}{A "node_member" membership vector.}
}
\value{
\code{plot.node_member()} returns a dendrogram, with labels colored to
indicate the different clusters, and with the optimal cutpoint shown by a
dashed highlight line.

\code{plot.matrix()} returns a plot of an adjacency or incidency matrix,
potentially with the rows and columns reordered to illustrate an additional
membership vector.
}
\description{
This plotting method operates on "node_member" class objects from the
\code{{manynet}} package, plotting the dendrogram of their membership.
}
\examples{
plot(manynet::node_in_walktrap(ison_southern_women, "e"))
plot(as_matrix(ison_adolescents),
  membership = node_in_walktrap(ison_adolescents, "e"))
plot(as_matrix(ison_southern_women),
  membership = node_in_walktrap(ison_southern_women, "e"))
}
