% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user-self.R
\name{arc_user_self}
\alias{arc_user_self}
\title{Discover Authenticated User Metadata}
\usage{
arc_user_self(
  host = arc_host(),
  token = arc_token(),
  error_call = rlang::caller_call()
)
}
\arguments{
\item{host}{default \code{"https://www.arcgis.com"}. The host of your ArcGIS Portal.}

\item{token}{an \code{httr2_token} as created by \code{auth_code()} or similar}

\item{error_call}{the caller environment to be used when propagating errors.}
}
\value{
a list of the authenticated user's metadata
}
\description{
Given an authentication token, return a list of user-specfic information such as the user ID, username, available credits, email, groups, last login date and more.
}
\examples{
\dontrun{
if (interactive()) {
  arc_user_self(token = auth_user())
}
}
}
\references{
\href{https://developers.arcgis.com/rest/users-groups-and-items/self/}{API Reference}
}
\keyword{portal}
\keyword{self}
