% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_profile.R
\name{rp}
\alias{rp}
\title{Generate a \code{SoilProfileCollection} of random profiles}
\usage{
rp(size, prefix = NULL, ...)
}
\arguments{
\item{size}{integer, number of requested profiles}

\item{prefix}{prefix added to zero-padded, integer IDs}

\item{...}{additional arguments to \code{\link[=random_profile]{random_profile()}}}
}
\value{
a \code{SoilProfileCollection} object
}
\description{
This function provides a convenient abstraction of \code{lapply()}, \code{\link[=random_profile]{random_profile()}}, and \code{\link[=combine]{combine()}} which are typically used together to create a \code{SoilProfileCollection} object with >1 soil profiles. \code{rp()} creates zero-padded integer IDs for logical sorting and indexing of profiles. For more complex IDs or additional flexibility, see \code{\link[=random_profile]{random_profile()}}. See \code{\link[=random_profile]{random_profile()}} for all possible arguments.
}
\examples{

# generate a SoilProfileCollection object with 10 profiles
# using 0-padded, integer IDs for intuitive sorting
spc <- rp(10, method = 'LPP')
plotSPC(spc, color = 'p1')

# apply a prefix to the IDs
spc <- rp(10, prefix = 'A-', method = 'LPP')
plotSPC(spc, color = 'p1')

}
