% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adk_data.R
\name{adk_data}
\alias{adk_data}
\title{Load ADK Data}
\usage{
adk_data(data_name)
}
\arguments{
\item{data_name}{A string choosing the data to load.
\tabular{ll}{
\strong{Data name (data_name)} \tab \strong{Data Description} \cr
chem \tab Lake Chemistry \cr
crustacean \tab Crustacean Zooplankton Biomass \cr
meta \tab Lake-specific metadata (type, location, morphology) \cr
nutrient \tab Lake Nutrients \cr
phyto \tab Phytoplankton Biomass Observations \cr
rotifer \tab Rotifer Zooplankton Biomass \cr
secchi \tab Lake Secchi Depth Observations \cr
tempdo \tab Temperature and Dissolved Oxygen Profiles \cr
met    \tab Lake-specific Meterology (air temp, wind, precip, etc) \cr
}}
}
\description{
Loads data from locally downloaded CSV files. Run \code{\link{check_dl_data}} before using this function.
}
\examples{
\dontrun{

#grab secchi data and plot it
secchi = adk_data('secchi')
plot(as.POSIXct(secchi$date), secchi$secchi)
}
}
