% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_wider_pknca_results.R
\name{pivot_wider_pknca_results}
\alias{pivot_wider_pknca_results}
\title{Reshape PKNCA Results}
\usage{
pivot_wider_pknca_results(myres)
}
\arguments{
\item{myres}{The output of PKNCA::pk.nca. It makes some additional assumptions:
\enumerate{
\item CDISC denomination of actual and nominal time variables (AFRLT, ARRLT, NFRLT, NRRLT).
\item Intervals must include a column (\code{type_interval}) to differentiate between the
custom AUC ranges ("manual") and main parameter calculations ("main").
\item Includes \code{PPSTRES} and \code{PPSTRESU} variables in results dataset.
\item Columns \code{start_dose} and \code{end_dose} must express the actual start and end times
of the dose, relative to the last reference dose.
\item Temporarily: CDISC denomination of PK parameters related to half-life: "LAMZNPT",
"LAMZLL", "LAMZ" Used to derive \code{LAMZNPT} and \code{LAMZMTD}.
}}
}
\value{
A data frame which provides an easy overview on the results from the NCA
in each profile/subject and how it was computed lambda (half life) and the results
of the NCA parameters (cmax, AUC, AUClast)
}
\description{
This function reshapes the structure of the results produced by the main function
of the PKNCA package (pk.nca) in a way that each row represents all the main results
summarized for each profile in each individual/subject. Excluding the ID variables,
each column name corresponds with a calculated parameter and between brackets its
corresponding units. AUC intervals, if present, are be added as additional columns.
}
