% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapley.R
\name{shapley}
\alias{shapley}
\title{Shapley value}
\usage{
shapley(
  characteristic_func,
  n_players = 0,
  method = "exact",
  n_rep = 10000,
  echo = TRUE
)
}
\arguments{
\item{characteristic_func}{The valued function defined on the subsets of the number
of players.}

\item{n_players}{Only used if \code{characteristic_func} is a \code{function}.
The number of players in the game.}

\item{method}{Method used to  alculate the Shapley value. Valid methods are:
\code{exact} for the exact calculation or \code{appro} for approximated polynomial
calculation based on sampling proposed by Castro et al. (2009).}

\item{n_rep}{Only used if \code{method} is \code{appro}. The number of
iterations to perform in the approximated calculation.}

\item{echo}{Only used if \code{method} is \code{appro}. Show progress of the
approximated calculation.}
}
\value{
The Shapley value for each player.
}
\description{
Calculate the Shapley value
}
\examples{
n <- 10
v <- function(coalition) {
if (length(coalition) > n/2) {
   return(1)
 } else {
   return(0)
 }
}
shapley(v, method = "appro", n_rep = 4000, n_players = n)

n <- 3
v <- c(1,1,2,1,2,2,2)
shapley(v, method = "exact")
shapley(v, method = "appro", n_rep = 4000)

}
\references{
Castro, J., Gómez, D., & Tejada, J. (2009). Polynomial calculation
of the Shapley value based on sampling. Computers & operations research,
36(5), 1726-1730.
}
