% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unconstrained_aGOE.R
\name{test_unconstrained_aGOE}
\alias{test_unconstrained_aGOE}
\title{Two Sample Test of Equal Eigenvalues Using GOE Approximation}
\usage{
test_unconstrained_aGOE(
  x,
  x2 = NULL,
  B = "chisq",
  nullevals = "av",
  scalestat = TRUE
)
}
\arguments{
\item{x}{A single sample of matrices (passed to \code{\link[=as_fsm]{as_fsm()}}) or
a list of two samples of matrices (passed to \code{\link[=as_kfsm]{as_kfsm()}}).}

\item{x2}{If \code{x} is a single sample then \code{x2} must be the second sample. Otherwise \code{x2} should be \code{NULL}.}

\item{B}{Number of bootstrap samples. If \code{B = 'chisq'} then a chi-squared calibration is used instead.}

\item{nullevals}{For internal testing of bootstrap calibration. \code{"av"} assumes the eigenvalues under the null hypothesis are the average of the eigenvalues of the two sample means. \code{"1"} and \code{"2"} assume the null eigenvalues are equal to the eigenvalue of the first and second sample respectively.}

\item{scalestat}{If \code{TRUE} then the statistic is divided by the estimated \eqn{a}. This modified statistic has approximately the same scale regardless of the data, although the thickness of the distribution tails (related to \eqn{v}) will vary. Simulations and bootstrapping behaviour more generally suggests that \code{scalestat=TRUE} leads to better test size and power when using bootstrap calibration.}
}
\value{
A \code{TFORGE} object (see \code{\link[=boot_calib]{boot_calib()}} or \code{\link[=chisq_calib]{chisq_calib()}}) including p-value of the test (slot \code{pval}) and the statistic for \code{x} (slot \code{t0}).
The returned object contains further slots specific to this test:
\itemize{
\item \code{a} Plug-in estimate of the \eqn{a} in the final equation of \insertCite{@Section 2.4, @schwartzman2010gr}{TFORGE}.
\item \code{v} Plug-in estimate of the \eqn{v} in the final equation of \insertCite{@Section 2.4, @schwartzman2010gr}{TFORGE}.
\item \code{var_Lambda_evals} The variance of the eigenvalues of Schwartzman et al \eqn{\Lambda}{Lambda} matrix, which may relate to the quality of the Welch-Satterthwaite approximation.
}
}
\description{
Applies the equal-eigenvalue hypothesis test between two samples by \insertCite{schwartzman2010gr;textual}{TFORGE}.
The null hypothesis is that the population means of each sample have the same eigenvalues, regardless of eigenvectors.
The test uses a statistic from the situation that both populations are Gaussian Orthogonal Ensembles (Gaussian-distributed independent elements with the variance on the off diagonal elements half that of the diagonal elements).
The distribution of this statistic for more general populations is approximated using a tangent space and the Welch-Satterthwaite approximation.
}
\details{
The test statistic is equation 11 of \insertCite{schwartzman2010gr}{TFORGE}.
For chi-squared calibration, the \eqn{p} value of the test is computed using the scaled chi-squared distribution reached at the end of \insertCite{@Section 2.4, @schwartzman2010gr}{TFORGE}. This distribution approximates the distribution of the test statistic and the scale \eqn{a} and degrees of freedom \eqn{v} are estimated from the data.
}
\references{
\insertAllCited{}
}
