% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger.R
\name{vcr_configure_log}
\alias{vcr_configure_log}
\alias{local_vcr_configure_log}
\title{Configure vcr logging}
\usage{
vcr_configure_log(
  log = TRUE,
  file = stderr(),
  include_date = NULL,
  log_prefix = "Cassette"
)

local_vcr_configure_log(
  log = TRUE,
  file = stderr(),
  include_date = NULL,
  log_prefix = "Cassette",
  frame = parent.frame()
)
}
\arguments{
\item{log}{Should we log important vcr things?}

\item{file}{A path or connection to log to}

\item{include_date}{(boolean) Include date and time in each log entry.}

\item{log_prefix}{"Cassette". We insert the cassette name after this prefix,
followed by the rest of the message.}

\item{frame}{Attach exit handlers to this environment. Typically, this
should be either the current environment or a parent frame (accessed
through \code{\link[=parent.frame]{parent.frame()}}). See \code{vignette("withr", package = "withr")}
for more details.}
}
\description{
By default, logging is disabled, but you can easily enable for the
entire session with \code{vcr_configure_log()} or for just one test with
\code{local_vcr_configure_log()}.
}
\examples{
# The default logs to stderr()
vcr_configure_log()

# But you might want to log to a file
vcr_configure_log(file = file.path(tempdir(), "vcr.log"))
}
