% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivs.R
\name{rxp_jl}
\alias{rxp_jl}
\title{Create a Nix expression running a Julia function}
\usage{
rxp_jl(
  name,
  expr,
  additional_files = "",
  user_functions = "",
  nix_env = "default.nix",
  encoder = NULL,
  decoder = NULL,
  env_var = NULL,
  noop_build = FALSE
)
}
\arguments{
\item{name}{Symbol, name of the derivation.}

\item{expr}{Character, Julia code to generate the expression. Ideally it
should be a call to a pure function. Multi-line expressions are not
supported.}

\item{additional_files}{Character vector, additional files to include
during the build process. For example, if a function expects a certain
file to be available, this is where you should include it.}

\item{user_functions}{Character vector, user-defined functions to include.
This should be a script (or scripts) containing user-defined functions
to include during the build process for this derivation. It is recommended
to use one script per function, and only include the required script(s) in
the derivation.}

\item{nix_env}{Character, path to the Nix environment file, default is
"default.nix".}

\item{encoder}{Character, defaults to NULL. The name of the Julia
function used to serialize the object. It must accept two arguments: the
object to serialize (first), and the target file path (second). If NULL,
the default behaviour uses the built‐in \code{Serialization.serialize} API. Define
any custom serializer in \code{functions.jl}. See \code{vignette("encoding-decoding")} for more details.}

\item{decoder}{Character or named vector/list, defaults to NULL. Can be:
\itemize{
\item A single string for the Julia function to unserialize all upstream objects
\item A named vector/list where names are upstream dependency names and values
are their specific unserialize functions
If NULL, the default is \code{Serialization.deserialize}. See \code{vignette("encoding-decoding")} for more details.
}}

\item{env_var}{Character vector, defaults to NULL. A named vector of
environment variables to set before running the Julia script, e.g.,
\code{c("JULIA_DEPOT_PATH" = "/path/to/depot")}. Each entry will be added as
an \code{export} statement in the build phase.}

\item{noop_build}{Logical, defaults to FALSE. If TRUE, the derivation
produces a no-op build (a stub output with no actual build steps). Any
downstream derivations depending on a no-op build will themselves also
become no-op builds.}
}
\value{
An object of class derivation which inherits from lists.
}
\description{
Create a Nix expression running a Julia function
}
\details{
At a basic level,
\code{rxp_jl(filtered_data, "filter(df, :col .> 10)")} is equivalent to
\verb{filtered_data = filter(df, :col .> 10)} in Julia. \code{rxp_jl()} generates the
required Nix boilerplate to output a so‐called "derivation" in Nix jargon.
A Nix derivation is a recipe that defines how to create an output (in this
case \code{filtered_data}) including its dependencies, build steps, and output
paths.
}
\examples{
\dontrun{
# Basic usage, no custom serializer
rxp_jl(
  name = filtered_df,
  expr = "filter(df, :col .> 10)"
)

# Skip building this derivation
rxp_jl(
  name = model_result,
  expr = "train_model(data)",
  noop_build = TRUE
)

# Custom serialization: assume `save_my_obj(obj, path)` is defined in functions.jl
rxp_jl(
  name = model_output,
  expr = "train_model(data)",
  encoder = "save_my_obj",
  user_functions = "functions.jl"
)
}
}
\seealso{
Other derivations: 
\code{\link{rxp_jl_file}()},
\code{\link{rxp_py}()},
\code{\link{rxp_py_file}()},
\code{\link{rxp_qmd}()},
\code{\link{rxp_r}()},
\code{\link{rxp_r_file}()},
\code{\link{rxp_rmd}()}
}
\concept{derivations}
