% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr_callbacks.R
\name{mlr3.holdout_task}
\alias{mlr3.holdout_task}
\title{Callback Holdout Task}
\arguments{
\item{task}{(\link{Task})\cr
The holdout task.}
}
\description{
This \link{CallbackResample} predicts on an additional holdout task after training.
}
\examples{
task = tsk("pima")
task_holdout = task$clone()
learner = lrn("classif.rpart")
resampling = rsmp("cv", folds = 3)
splits = partition(task, 0.7)

task$filter(splits$train)
task_holdout$filter(splits$test)

callback = clbk("mlr3.holdout_task", task = task_holdout)

rr = resample(task, learner, resampling = resampling, callbacks = callback)

rr$data_extra
}
