% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_display.R
\name{joyn_msg}
\alias{joyn_msg}
\title{display type of joyn message}
\usage{
joyn_msg(msg_type = getOption("joyn.msg_type"), msg = NULL)
}
\arguments{
\item{msg_type}{character: one or more of the following:
all, basic, info, note, warn, timing, or err}

\item{msg}{character vector to be parsed to \code{\link[cli:cli_abort]{cli::cli_abort()}}. Default is
NULL. It only works if \code{"err" \%in\% msg_type}. This is an internal argument.}
}
\value{
returns data frame with message invisibly. print message in console
}
\description{
display type of joyn message
}
\examples{
library(data.table)
x1 = data.table(id = c(1L, 1L, 2L, 3L, NA_integer_),
t  = c(1L, 2L, 1L, 2L, NA_integer_),
x  = 11:15)

y1 = data.table(id = 1:2,
                y  = c(11L, 15L))
df <- joyn(x1, y1, match_type = "m:1")
joyn_msg("basic")
joyn_msg("all")
}
\seealso{
Messages functions
\code{\link{clear_joynenv}()},
\code{\link{joyn_msgs_exist}()},
\code{\link{joyn_report}()},
\code{\link{msg_type_dt}()},
\code{\link{store_msg}()},
\code{\link{style}()},
\code{\link{type_choices}()}
}
\concept{messages}
