% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmvnorm_.R
\name{mvrnorm2}
\alias{mvrnorm2}
\title{Expand Types of \code{Sigma} in \link[MASS]{mvrnorm}}
\usage{
mvrnorm2(n, mu, Sigma, ...)
}
\arguments{
\item{n}{\link[base]{integer} scalar, sample size}

\item{mu}{\link[base]{numeric} scalar or \link[base]{vector},
multivariate means \eqn{\mathbf{\mu}}'s}

\item{Sigma}{\link[base]{numeric}, either
a scalar, a \link[base]{vector} or a \link[base]{matrix},
\link[stats]{var}iance-\link[stats]{cov}ariance
\link[base]{matrix} \eqn{\Sigma}}

\item{...}{additional parameter of function \link[MASS]{mvrnorm}}
}
\value{
Function \code{\link[=mvrnorm2]{mvrnorm2()}} returns a \link[base]{double} \link[base]{matrix}.
}
\description{
To accommodate more types of \code{Sigma} in function \link[MASS]{mvrnorm}.
}
\details{
Argument of parameter \code{Sigma} could be
\describe{
\item{scalar}{First, \code{Sigma} is recycled to the \link[base]{length} of \code{mu}.
Then a \link[base]{diag}onal \link[base]{matrix} with \link[base]{vector} \code{Sigma} on the diagonal elements
is used as the \link[stats]{var}iance-\link[stats]{cov}ariance
\link[base]{matrix} \eqn{\Sigma}}
\item{\link[base]{vector}}{First, check that \link[base]{length} of \code{Sigma} and \code{mu} must be the same.
Then the \link[base]{diag}onal \link[base]{matrix} is used as \eqn{\Sigma}}
\item{\link[base]{matrix}}{\code{Sigma} is used as \eqn{\Sigma}}}
}
\note{
Workhorse function \link[MASS]{mvrnorm} from package \CRANpkg{MASS} is faster than \code{?mvtnorm::rmvnorm}.
}
\keyword{internal}
