% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulations-methods.R
\name{summary,PseudoSimulations-method}
\alias{summary,PseudoSimulations-method}
\alias{summary-PseudoSimulations}
\title{Summarize \code{PseudoSimulations}}
\usage{
\S4method{summary}{PseudoSimulations}(object, truth, targetEndOfTrial = 0.3, targetDuringTrial = 0.35, ...)
}
\arguments{
\item{object}{(\code{PseudoSimulations})\cr the object we want to summarize.}

\item{truth}{(\code{function})\cr a function which takes as input a dose (vector)
and returns the true probability (vector) for toxicity.}

\item{targetEndOfTrial}{(\code{number})\cr the target probability of DLE wanted
to achieve at the end of a trial.}

\item{targetDuringTrial}{(\code{number})\cr the target probability of DLE wanted
to achieve during a trial.}

\item{...}{additional arguments can be supplied here for \code{truth}.}
}
\value{
An object of class \code{\link{PseudoSimulationsSummary}}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Summarize the simulations, relative to a given truth.
}
\examples{
emptydata <- Data(doseGrid = seq(25, 300, 25))

# The design incorporate DLE responses and DLE samples.
# Specify the model of 'ModelTox' class eg 'LogisticIndepBeta' class model.
my_model <- LogisticIndepBeta(
  binDLE = c(1.05, 1.8),
  DLEweights = c(3, 3),
  DLEdose = c(25, 300),
  data = emptydata
)

# The escalation rule.
td_next_best <- NextBestTD(
  prob_target_drt = 0.35,
  prob_target_eot = 0.3
)

# Cohort size is 3 subjects.
my_size <- CohortSizeConst(size = 3)

# Allow increase of 200\%.
my_increments <- IncrementsRelative(intervals = 0, increments = 2)

# Stopp when the maximum sample size of 36 patients has been reached or the next
# dose is NA.
my_stopping <- StoppingMinPatients(nPatients = 36) | StoppingMissingDose()

# Specify the design. (For details please refer to the 'TDDesign' example.)
my_design <- TDDesign(
  model = my_model,
  nextBest = td_next_best,
  stopping = my_stopping,
  increments = my_increments,
  cohort_size = my_size,
  data = emptydata,
  startingDose = 25
)

# Specify the truth of the DLE responses.
my_truth <- probFunction(my_model, phi1 = -53.66584, phi2 = 10.50499)

# For illustration purpose 50 burn-ins to generate 200 samples are used.
my_options <- McmcOptions(burnin = 50, step = 2, samples = 200)

# Refer to design-method 'simulate TDDesign' examples for details.
# For illustration purpose only 1 simulation is produced.
my_sim <- simulate(
  object = my_design,
  args = NULL,
  truth = my_truth,
  nsim = 1,
  seed = 819,
  parallel = FALSE,
  mcmcOptions = my_options
)

# Produce a summary of the simulations.
summary(
  my_sim,
  truth = my_truth
)

# Example where DLE samples are involved.

# Specify the next best rule.
td_next_best <- NextBestTDsamples(
  prob_target_drt = 0.35,
  prob_target_eot = 0.3,
  derive = function(samples) {
    as.numeric(quantile(samples, probs = 0.3))
  }
)

# The design.
my_design <- TDsamplesDesign(
  model = my_model,
  nextBest = td_next_best,
  stopping = my_stopping,
  increments = my_increments,
  cohort_size = my_size,
  data = emptydata,
  startingDose = 25
)

# For illustration purpose 50 burn-ins to generate 200 samples are used.
my_options <- McmcOptions(burnin = 50, step = 2, samples = 200)

# For illustration purpose 2 trials are simulated.
my_sim <- simulate(
  object = my_design,
  args = NULL,
  truth = my_truth,
  nsim = 2,
  seed = 819,
  mcmcOptions = my_options,
  parallel = FALSE
)

# Produce a summary of the simulations.
summary(
  my_sim,
  truth = my_truth
)
}
