% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_tabulate_max.R
\name{ard_tabulate_max}
\alias{ard_tabulate_max}
\title{ARD to Calculate Categorical Occurrence Rates by Maximum Level Per Unique ID}
\usage{
ard_tabulate_max(
  data,
  variables,
  id,
  by = dplyr::group_vars(data),
  statistic = everything() ~ c("n", "p", "N"),
  denominator = NULL,
  strata = NULL,
  fmt_fun = NULL,
  stat_label = everything() ~ cards::default_stat_labels(),
  quiet = FALSE,
  fmt_fn = deprecated(),
  ...
)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
The categorical variables for which occurrence rates per unique ID (by maximum level) will be calculated.}

\item{id}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Argument used to subset \code{data} to identify rows in \code{data} to calculate categorical variable level occurrence rates.}

\item{by, strata}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to use for grouping or stratifying the table output.
Arguments are similar, but with an important distinction:

\code{by}: results are tabulated by \strong{all combinations} of the columns specified,
including unobserved combinations and unobserved factor levels.

\code{strata}: results are tabulated by \strong{all \emph{observed} combinations} of the
columns specified.

Arguments may be used in conjunction with one another.}

\item{statistic}{(\code{\link[cards:syntax]{formula-list-selector}})\cr
a named list, a list of formulas,
or a single formula where the list element one or more of  \code{c("n", "N", "p", "n_cum", "p_cum")}
(on the RHS of a formula).}

\item{denominator}{(\code{data.frame}, \code{integer})\cr
An optional argument to change the denominator used for \code{"N"} and \code{"p"} statistic calculations.
Defaults to \code{NULL}, in which case \code{dplyr::distinct(data, dplyr::pick(all_of(c(id, by))))} is used for these
calculations. See \code{\link[cards:ard_tabulate]{cards::ard_tabulate()}} for more details on specifying denominators.}

\item{fmt_fun}{(\code{\link[cards:syntax]{formula-list-selector}})\cr
a named list, a list of formulas,
or a single formula where the list element is a named list of functions
(or the RHS of a formula),
e.g. \verb{list(mpg = list(mean = \\(x) round(x, digits = 2) |> as.character()))}.}

\item{stat_label}{(\code{\link[cards:syntax]{formula-list-selector}})\cr
a named list, a list of formulas, or a single formula where
the list element is either a named list or a list of formulas defining the
statistic labels, e.g. \code{everything() ~ list(n = "n", p = "pct")} or
\code{everything() ~ list(n ~ "n", p ~ "pct")}.}

\item{quiet}{(scalar \code{logical})\cr
Logical indicating whether to suppress additional messaging. Default is \code{FALSE}.}

\item{fmt_fn}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{...}{Arguments passed to methods.}
}
\value{
an ARD data frame of class 'card'
}
\description{
Function calculates categorical variable level occurrences rates by maximum level per unique ID.
Each variable in \code{variables} is evaluated independently and then results for all variables are stacked.
Only the highest-ordered level will be counted for each unique ID.
Unordered, non-numeric variables will be converted to factor and the default level order used for ordering.
}
\examples{
# Occurrence Rates by Max Level (Highest Severity) --------------------------
ard_tabulate_max(
  cards::ADAE,
  variables = c(AESER, AESEV),
  id = USUBJID,
  by = TRTA,
  denominator = cards::ADSL
)
}
