% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noise-blue.R
\name{noise_blue}
\alias{noise_blue}
\title{Blue noise generator}
\usage{
noise_blue(dim, sd = 10, seed_frac = 0.1)
}
\arguments{
\item{dim}{The dimensions (height, width, (and depth, (and time))) of the
noise to be generated. The length determines the dimensionality of the noise.}

\item{sd}{The standard deviation of the gaussian filter to apply during the
search for clusters and voids.}

\item{seed_frac}{The fraction of pixels to seed the algorithm with during
start}
}
\value{
For \code{noise_white()} a vector if \code{length(dim) == 1}, matrix if
\code{length(dim) == 2} or an array if \code{length(dim) >= 3}.
}
\description{
Blue noise is a form of noise that has weak low-frequency. This means that
it is devoid of larger structures and can be blurred to an even gray. Blue
noise in ambient is calculated using the popular Void-and-cluster method
developed by Ulichney. Calculating blue noise is much more computationally
expensive than e.g. white noise so ambient does not provide a \code{gen_blue()}
generator, only the \code{noise_blue()} texture function. Computation time
increases linearly with the number of pixels in the texture and can get
prohibitly long very soon. However, blue noise is tile-able so a good
suggestion is to try tiling e.g. a 64x64 texture to the desired dimensions
and see if that suffices.
}
\examples{
# Basic use
noise <- noise_blue(c(64, 64))

plot(as.raster(normalise(noise)))

}
\references{
R. A. Ulichney (1993). \emph{Void-and-cluster method for dither array generation}. Proc. SPIE 1913, Human Vision, Visual Processing, and Digital Display IV
}
